/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.actions;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.DefaultTextPropertyProviderImpl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProvider;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultTextPropertyProviderImplTest {
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;
    @Mock
    private Element<? extends Definition> element;
    @Mock
    private Definition content;
    @Mock
    private Definition definition;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private CanvasCommandManager<AbstractCanvasHandler> commandManager;
    @Mock
    private CanvasCommand<AbstractCanvasHandler> command;
    private TextPropertyProvider provider;

    @Before
    public void setup() {
        this.provider = new DefaultTextPropertyProviderImpl(this.definitionUtils, this.canvasCommandFactory);
        Mockito.when((Object)this.element.getContent()).thenReturn((Object)this.content);
        Mockito.when((Object)this.content.getDefinition()).thenReturn((Object)this.definition);
        Mockito.when((Object)this.definitionUtils.getNameIdentifier(Matchers.eq((Object)this.definition))).thenReturn((Object)"name");
        Mockito.when((Object)this.canvasCommandFactory.updatePropertyValue((Element)Matchers.eq(this.element), Mockito.anyString(), (Object)Mockito.anyString())).thenReturn(this.command);
    }

    @Test
    public void checkPriorityEnsuresCatchAllOperation() {
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)this.provider.getPriority());
    }

    @Test
    public void checkSupportsAllElements() {
        Assert.assertTrue((boolean)this.provider.supports(this.element));
    }

    @Test
    public void checkReadGetsNameFromPropertyMetaData() {
        this.provider.getText(this.element);
        ((DefinitionUtils)Mockito.verify((Object)this.definitionUtils)).getName(Matchers.eq((Object)this.definition));
    }

    @Test
    public void checkWriteUsesCommandToUpdateNamePropertyMetaData() {
        this.provider.setText(this.canvasHandler, this.commandManager, this.element, "text");
        ((CanvasCommandFactory)Mockito.verify(this.canvasCommandFactory)).updatePropertyValue((Element)Matchers.eq(this.element), (String)Matchers.eq((Object)"name"), Matchers.eq((Object)"text"));
        ((CanvasCommandManager)Mockito.verify(this.commandManager)).execute(Matchers.eq((Object)this.canvasHandler), (Command)Matchers.eq(this.command));
    }
}

