/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.actions;

import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProvider;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProviderFactory;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProviderFactoryImpl;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.mocks.MockInstanceImpl;

@RunWith(value=MockitoJUnitRunner.class)
public class TextPropertyProviderFactoryTest {
    @Mock
    private Element element;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> commandManagerProvider;
    private TextPropertyProviderFactory factory;
    private TextPropertyProvider provider1 = this.makeTextPropertyProvider(2);
    private TextPropertyProvider provider2 = this.makeTextPropertyProvider(1);

    @Before
    public void setup() {
        MockInstanceImpl providers = new MockInstanceImpl((Object[])new TextPropertyProvider[]{this.provider1, this.provider2});
        ManagedInstance managedProviders = (ManagedInstance)Mockito.mock(ManagedInstance.class);
        Mockito.when((Object)managedProviders.iterator()).thenReturn((Object)providers.iterator());
        this.factory = new TextPropertyProviderFactoryImpl(managedProviders);
    }

    @Test
    public void checkFactoryOrdersProvidersByPriorityAscending() {
        TextPropertyProvider provider = this.factory.getProvider(this.element);
        Assert.assertEquals((Object)this.provider2, (Object)provider);
    }

    private TextPropertyProvider makeTextPropertyProvider(int priority) {
        TextPropertyProvider provider = (TextPropertyProvider)Mockito.mock(TextPropertyProvider.class);
        Mockito.when((Object)provider.supports((Element)Mockito.any(Element.class))).thenReturn((Object)true);
        Mockito.when((Object)provider.getPriority()).thenReturn((Object)priority);
        return provider;
    }
}

