/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.select;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Layer;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.SelectionControlImpl;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasElementSelectedEvent;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.ShapeViewExtStub;
import org.kie.workbench.common.stunner.core.client.shape.view.HasControlPoints;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class SelectionControlImplTest {
    private static final String ROOT_UUID = "root-uuid1";
    private static final String ELEMENT_UUID = "element-uuid1";
    @Mock
    private EventSourceMock<CanvasElementSelectedEvent> elementSelectedEvent;
    @Mock
    private EventSourceMock<CanvasClearSelectionEvent> clearSelectionEvent;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private AbstractCanvas canvas;
    @Mock
    private Layer layer;
    @Mock
    private Diagram diagram;
    @Mock
    private Metadata metadata;
    @Mock
    private Element element;
    @Mock
    private Shape<?> shape;
    @Mock
    private HasEventHandlers<ShapeViewExtStub, Object> shapeEventHandler;
    @Mock
    private HasControlPoints<ShapeViewExtStub> hasControlPoints;
    private ShapeViewExtStub shapeView;
    private SelectionControlImpl<AbstractCanvasHandler> tested;

    @Before
    public void setup() throws Exception {
        this.shapeView = new ShapeViewExtStub(this.shapeEventHandler, this.hasControlPoints);
        Mockito.when((Object)this.element.getUUID()).thenReturn((Object)ELEMENT_UUID);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.diagram.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.metadata.getCanvasRootUUID()).thenReturn((Object)ROOT_UUID);
        Mockito.when((Object)this.canvasHandler.getCanvas()).thenReturn((Object)this.canvas);
        Mockito.when((Object)this.canvas.getLayer()).thenReturn((Object)this.layer);
        Mockito.when((Object)this.canvas.getShape((String)Matchers.eq((Object)ELEMENT_UUID))).thenReturn(this.shape);
        Mockito.when((Object)this.canvas.getShapes()).thenReturn(Collections.singletonList(this.shape));
        Mockito.when((Object)this.shape.getUUID()).thenReturn((Object)ELEMENT_UUID);
        Mockito.when((Object)this.shape.getShapeView()).thenReturn((Object)this.shapeView);
        Mockito.when((Object)this.shapeEventHandler.supports((ViewEventType)Matchers.eq((Object)ViewEventType.MOUSE_CLICK))).thenReturn((Object)true);
        this.tested = new SelectionControlImpl(this.elementSelectedEvent, this.clearSelectionEvent);
    }

    @Test
    public void testEnable() {
        this.tested.enable(this.canvasHandler);
        ((Layer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).addHandler((ViewEventType)Matchers.eq((Object)ViewEventType.MOUSE_CLICK), (ViewHandler)Matchers.any(MouseClickHandler.class));
    }

    @Test
    public void testLayerClickAndSelectRootElement() {
        this.tested.enable(this.canvasHandler);
        ArgumentCaptor clickHandlerArgumentCaptor = ArgumentCaptor.forClass(MouseClickHandler.class);
        ((Layer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).addHandler((ViewEventType)Matchers.eq((Object)ViewEventType.MOUSE_CLICK), (ViewHandler)clickHandlerArgumentCaptor.capture());
        MouseClickHandler clickHandler = (MouseClickHandler)clickHandlerArgumentCaptor.getValue();
        MouseClickEvent event = new MouseClickEvent(12.0, 20.0, 30.0, 40.0);
        event.setButtonLeft(true);
        event.setShiftKeyDown(false);
        clickHandler.handle((ViewEvent)event);
        ArgumentCaptor elementSelectedEventArgumentCaptor = ArgumentCaptor.forClass(CanvasElementSelectedEvent.class);
        ((EventSourceMock)Mockito.verify(this.elementSelectedEvent, (VerificationMode)Mockito.times((int)1))).fire(elementSelectedEventArgumentCaptor.capture());
        ((EventSourceMock)Mockito.verify(this.clearSelectionEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(CanvasClearSelectionEvent.class));
        CanvasElementSelectedEvent ese = (CanvasElementSelectedEvent)elementSelectedEventArgumentCaptor.getValue();
        Assert.assertEquals((Object)ROOT_UUID, (Object)ese.getElementUUID());
    }

    @Test
    public void testLayerClickAndClear() {
        Mockito.when((Object)this.metadata.getCanvasRootUUID()).thenReturn(null);
        this.tested.enable(this.canvasHandler);
        ArgumentCaptor clickHandlerArgumentCaptor = ArgumentCaptor.forClass(MouseClickHandler.class);
        ((Layer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).addHandler((ViewEventType)Matchers.eq((Object)ViewEventType.MOUSE_CLICK), (ViewHandler)clickHandlerArgumentCaptor.capture());
        MouseClickHandler clickHandler = (MouseClickHandler)clickHandlerArgumentCaptor.getValue();
        MouseClickEvent event = new MouseClickEvent(12.0, 20.0, 30.0, 40.0);
        event.setButtonLeft(true);
        event.setShiftKeyDown(false);
        clickHandler.handle((ViewEvent)event);
        ((EventSourceMock)Mockito.verify(this.clearSelectionEvent, (VerificationMode)Mockito.times((int)2))).fire(Matchers.any(CanvasClearSelectionEvent.class));
        ((EventSourceMock)Mockito.verify(this.elementSelectedEvent, (VerificationMode)Mockito.never())).fire(Matchers.any(CanvasElementSelectedEvent.class));
    }

    @Test
    public void testRegisterElement() {
        this.tested.enable(this.canvasHandler);
        Assert.assertFalse((boolean)this.tested.isRegistered(this.element));
        this.tested.register(this.element);
        ((HasEventHandlers)Mockito.verify(this.shapeEventHandler, (VerificationMode)Mockito.times((int)1))).supports((ViewEventType)Matchers.eq((Object)ViewEventType.MOUSE_CLICK));
        ((HasEventHandlers)Mockito.verify(this.shapeEventHandler, (VerificationMode)Mockito.times((int)1))).addHandler((ViewEventType)Matchers.eq((Object)ViewEventType.MOUSE_CLICK), (ViewHandler)Matchers.any(MouseClickHandler.class));
        Assert.assertTrue((boolean)this.tested.isRegistered(this.element));
    }

    @Test
    public void testSelect() {
        this.tested.enable(this.canvasHandler);
        Assert.assertFalse((boolean)this.tested.isRegistered(this.element));
        this.tested.register(this.element);
        ArgumentCaptor clickHandlerArgumentCaptor = ArgumentCaptor.forClass(MouseClickHandler.class);
        ((HasEventHandlers)Mockito.verify(this.shapeEventHandler, (VerificationMode)Mockito.times((int)1))).addHandler((ViewEventType)Matchers.eq((Object)ViewEventType.MOUSE_CLICK), (ViewHandler)clickHandlerArgumentCaptor.capture());
        Assert.assertTrue((boolean)this.tested.isRegistered(this.element));
        MouseClickHandler clickHandler = (MouseClickHandler)clickHandlerArgumentCaptor.getValue();
        MouseClickEvent event = new MouseClickEvent(12.0, 20.0, 30.0, 40.0);
        event.setButtonLeft(true);
        event.setShiftKeyDown(false);
        clickHandler.handle((ViewEvent)event);
        ((Shape)Mockito.verify(this.shape, (VerificationMode)Mockito.times((int)1))).applyState((ShapeState)Matchers.eq((Object)ShapeState.SELECTED));
        Assert.assertEquals((long)1L, (long)this.tested.getSelectedItems().size());
        Assert.assertEquals((Object)ELEMENT_UUID, this.tested.getSelectedItems().iterator().next());
    }

    @Test
    public void testDeregisterElement() {
        this.tested.enable(this.canvasHandler);
        this.tested.register(this.element);
        this.tested.deregister(this.element);
        ((HasEventHandlers)Mockito.verify(this.shapeEventHandler, (VerificationMode)Mockito.times((int)1))).removeHandler((ViewHandler)Matchers.any(ViewHandler.class));
        Assert.assertFalse((boolean)this.tested.isRegistered(this.element));
    }

    @Test
    public void testDisable() {
        this.tested.enable(this.canvasHandler);
        this.tested.disable();
        ((Layer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).removeHandler((ViewHandler)Matchers.any(ViewHandler.class));
    }
}

