/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.AbstractToolboxControlProvider;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.FlowActionsToolboxControlProvider;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.ToolboxCommandFactory;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.builder.NewConnectorCommand;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.builder.NewNodeCommand;
import org.kie.workbench.common.stunner.core.client.components.toolbox.ToolboxFactory;
import org.kie.workbench.common.stunner.core.client.components.toolbox.builder.ToolboxBuilder;
import org.kie.workbench.common.stunner.core.client.components.toolbox.builder.ToolboxButtonGridBuilder;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionSetAdapter;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.lookup.util.CommonLookups;
import org.kie.workbench.common.stunner.core.registry.definition.TypeDefinitionSetRegistry;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FlowActionsToolboxControlProviderTest {
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private ToolboxFactory toolboxFactory;
    @Mock
    private ToolboxButtonGridBuilder toolboxButtonGridBuilder;
    @Mock
    private DefinitionManager definitionManager;
    @Mock
    private FactoryManager factoryManager;
    @Mock
    private ToolboxCommandFactory defaultToolboxCommandFactory;
    @Mock
    private CommonLookups commonLookups;
    @Mock
    private TypeDefinitionSetRegistry typeDefinitionSetRegistry;
    @Mock
    private AdapterManager adapterManager;
    @Mock
    private DefinitionSetAdapter definitionSetAdapter;
    @Mock
    private DefinitionAdapter definitionAdapter;
    private AbstractToolboxControlProvider provider;

    @Before
    public void setup() {
        Mockito.when((Object)this.definitionUtils.getDefinitionManager()).thenReturn((Object)this.definitionManager);
        Mockito.when((Object)this.toolboxFactory.toolboxGridBuilder()).thenReturn((Object)this.toolboxButtonGridBuilder);
        Mockito.when((Object)this.toolboxButtonGridBuilder.setRows(Mockito.anyInt())).thenReturn((Object)this.toolboxButtonGridBuilder);
        Mockito.when((Object)this.toolboxButtonGridBuilder.setColumns(Mockito.anyInt())).thenReturn((Object)this.toolboxButtonGridBuilder);
        Mockito.when((Object)this.toolboxButtonGridBuilder.setIconSize(Mockito.anyInt())).thenReturn((Object)this.toolboxButtonGridBuilder);
        Mockito.when((Object)this.toolboxButtonGridBuilder.setPadding(Mockito.anyInt())).thenReturn((Object)this.toolboxButtonGridBuilder);
        Mockito.when((Object)this.definitionManager.definitionSets()).thenReturn((Object)this.typeDefinitionSetRegistry);
        Mockito.when((Object)this.typeDefinitionSetRegistry.getDefinitionSetByType((Class)Mockito.eq(MockDefinitionSet.class))).thenReturn((Object)new MockDefinitionSet());
        Mockito.when((Object)this.definitionManager.adapters()).thenReturn((Object)this.adapterManager);
        Mockito.when((Object)this.adapterManager.forDefinitionSet()).thenReturn((Object)this.definitionSetAdapter);
        Mockito.when((Object)this.adapterManager.forDefinition()).thenReturn((Object)this.definitionAdapter);
        Mockito.when((Object)this.definitionSetAdapter.getDefinitions(Mockito.any(MockDefinitionSet.class))).thenReturn((Object)new HashSet<String>(){
            {
                this.add(MockNode.class.getName());
                this.add(MockConnector.class.getName());
            }
        });
        Mockito.when((Object)this.definitionAdapter.getId(Mockito.anyObject())).thenAnswer(o -> o.getArguments()[0].getClass().getName());
        this.provider = new FlowActionsToolboxControlProvider(this.toolboxFactory, this.definitionUtils, this.defaultToolboxCommandFactory, this.commonLookups);
    }

    @Test
    public void checkGridHasExpectedConfiguration() {
        AbstractCanvasHandler context = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        Element item = (Element)Mockito.mock(Element.class);
        this.provider.getGrid((CanvasHandler)context, (Object)item);
        ((ToolboxButtonGridBuilder)Mockito.verify((Object)this.toolboxButtonGridBuilder)).setRows(5);
        ((ToolboxButtonGridBuilder)Mockito.verify((Object)this.toolboxButtonGridBuilder)).setColumns(2);
        ((ToolboxButtonGridBuilder)Mockito.verify((Object)this.toolboxButtonGridBuilder)).setIconSize(17);
        ((ToolboxButtonGridBuilder)Mockito.verify((Object)this.toolboxButtonGridBuilder)).setPadding(9);
        ((ToolboxButtonGridBuilder)Mockito.verify((Object)this.toolboxButtonGridBuilder)).build();
    }

    @Test
    public void checkGetOnIsNorthEast() {
        Assert.assertEquals((Object)ToolboxBuilder.Direction.NORTH_EAST, (Object)this.provider.getOn());
    }

    @Test
    public void checkGetTowardsIsSouthEast() {
        Assert.assertEquals((Object)ToolboxBuilder.Direction.SOUTH_EAST, (Object)this.provider.getTowards());
    }

    @Test
    public void checkGetCommandsForAvailableConnectors() {
        AbstractCanvasHandler context = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        this.setupDiagramMetaData(context);
        Node node = (Node)Mockito.mock(Node.class);
        NewConnectorCommand newConnectorCommand = (NewConnectorCommand)Mockito.mock(NewConnectorCommand.class);
        Mockito.when((Object)this.commonLookups.getAllowedConnectors((String)Mockito.eq((Object)MockDefinitionSet.class.getName()), (Node)Mockito.eq((Object)node), Mockito.anyInt(), Mockito.anyInt())).thenReturn(Collections.singleton(MockConnector.class.getName()));
        Mockito.when((Object)this.defaultToolboxCommandFactory.newConnectorToolboxCommand()).thenReturn((Object)newConnectorCommand);
        List commands = this.provider.getCommands((CanvasHandler)context, (Object)node);
        Assert.assertEquals((long)1L, (long)commands.size());
        Assert.assertTrue((boolean)commands.contains(newConnectorCommand));
        ((NewConnectorCommand)Mockito.verify((Object)newConnectorCommand)).setEdgeIdentifier((String)Mockito.eq((Object)MockConnector.class.getName()));
    }

    @Test
    public void checkGetCommandsForAvailableConnectorAndFlowNode() {
        AbstractCanvasHandler context = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        this.setupDiagramMetaData(context);
        Node node = (Node)Mockito.mock(Node.class);
        NewConnectorCommand newConnectorCommand = (NewConnectorCommand)Mockito.mock(NewConnectorCommand.class);
        Mockito.when((Object)this.commonLookups.getAllowedConnectors((String)Mockito.eq((Object)MockDefinitionSet.class.getName()), (Node)Mockito.eq((Object)node), Mockito.anyInt(), Mockito.anyInt())).thenReturn(Collections.singleton(MockConnector.class.getName()));
        Mockito.when((Object)this.defaultToolboxCommandFactory.newConnectorToolboxCommand()).thenReturn((Object)newConnectorCommand);
        Mockito.when((Object)this.definitionUtils.getDefaultConnectorId((String)Mockito.eq((Object)MockDefinitionSet.class.getName()))).thenReturn((Object)MockConnector.class.getName());
        NewNodeCommand newNodeCommand = (NewNodeCommand)Mockito.mock(NewNodeCommand.class);
        Mockito.when((Object)this.commonLookups.getAllowedMorphDefaultDefinitions((String)Mockito.eq((Object)MockDefinitionSet.class.getName()), (Graph)Mockito.any(Graph.class), (Node)Mockito.eq((Object)node), (String)Mockito.eq((Object)MockConnector.class.getName()), Mockito.anyInt(), Mockito.anyInt())).thenReturn(Collections.singleton(MockNode.class.getName()));
        Mockito.when((Object)this.defaultToolboxCommandFactory.newNodeToolboxCommand()).thenReturn((Object)newNodeCommand);
        List commands = this.provider.getCommands((CanvasHandler)context, (Object)node);
        Assert.assertEquals((long)2L, (long)commands.size());
        Assert.assertTrue((boolean)commands.contains(newConnectorCommand));
        ((NewConnectorCommand)Mockito.verify((Object)newConnectorCommand)).setEdgeIdentifier((String)Mockito.eq((Object)MockConnector.class.getName()));
        Assert.assertTrue((boolean)commands.contains(newNodeCommand));
        ((NewNodeCommand)Mockito.verify((Object)newNodeCommand)).setEdgeIdentifier((String)Mockito.eq((Object)MockConnector.class.getName()));
        ((NewNodeCommand)Mockito.verify((Object)newNodeCommand)).setDefinitionIdentifier((String)Mockito.eq((Object)MockNode.class.getName()));
    }

    private void setupDiagramMetaData(AbstractCanvasHandler context) {
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        Mockito.when((Object)context.getDiagram()).thenReturn((Object)diagram);
        Mockito.when((Object)diagram.getMetadata()).thenReturn((Object)metadata);
        Mockito.when((Object)metadata.getDefinitionSetId()).thenReturn((Object)MockDefinitionSet.class.getName());
    }

    private static class MockConnector {
        private MockConnector() {
        }
    }

    private static class MockNode {
        private MockNode() {
        }
    }

    private static class MockDefinitionSet {
        private MockDefinitionSet() {
        }
    }
}

