/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.util;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasExport;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Layer;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasFileExport;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.editor.commons.client.file.exports.FileExport;
import org.uberfire.ext.editor.commons.client.file.exports.ImageDataUriContent;
import org.uberfire.ext.editor.commons.client.file.exports.PdfDocument;
import org.uberfire.ext.editor.commons.file.exports.FileExportsPreferences;
import org.uberfire.ext.editor.commons.file.exports.PdfExportPreferences;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=MockitoJUnitRunner.class)
public class CanvasFileExportTest {
    private static final String TITLE = "theTitle";
    private static final String JPG_DATA_URI = "data:image/jpeg;base64,the-jpg-data-goes-here";
    private static final String PNG_DATA_URI = "data:image/png;base64,the-png-data-goes-here";
    @Mock
    private CanvasExport<AbstractCanvasHandler> canvasExport;
    @Mock
    private FileExport<ImageDataUriContent> imageFileExport;
    @Mock
    private FileExport<PdfDocument> pdfFileExport;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Diagram diagram;
    @Mock
    private Metadata metadata;
    @Mock
    private FileExportsPreferences preferences;
    private CanvasFileExport tested;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.diagram.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.metadata.getTitle()).thenReturn((Object)TITLE);
        PdfExportPreferences defaultPdfPrefs = PdfExportPreferences.create((PdfExportPreferences.Orientation)PdfExportPreferences.Orientation.PORTRAIT, (PdfExportPreferences.Unit)PdfExportPreferences.Unit.MM, (PdfExportPreferences.Format)PdfExportPreferences.Format.A4);
        Mockito.when((Object)this.preferences.getPdfPreferences()).thenReturn((Object)defaultPdfPrefs);
        ((FileExportsPreferences)Mockito.doAnswer(invocationOnMock -> {
            ParameterizedCommand callback = (ParameterizedCommand)invocationOnMock.getArguments()[0];
            callback.execute((Object)this.preferences);
            return null;
        }).when((Object)this.preferences)).load((ParameterizedCommand)Matchers.any(ParameterizedCommand.class), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
        this.tested = new CanvasFileExport(this.canvasExport, this.imageFileExport, this.pdfFileExport, this.preferences);
    }

    @Test
    public void testExportToJpg() {
        Mockito.when((Object)this.canvasExport.toImageData((CanvasHandler)Matchers.eq((Object)this.canvasHandler), (Layer.URLDataType)Matchers.eq((Object)Layer.URLDataType.JPG))).thenReturn((Object)JPG_DATA_URI);
        this.tested.exportToJpg(this.canvasHandler, "file1");
        ArgumentCaptor contentArgumentCaptor = ArgumentCaptor.forClass(ImageDataUriContent.class);
        ((FileExport)Mockito.verify(this.imageFileExport, (VerificationMode)Mockito.times((int)1))).export(contentArgumentCaptor.capture(), (String)Matchers.eq((Object)"file1.jpg"));
        ((FileExport)Mockito.verify(this.pdfFileExport, (VerificationMode)Mockito.never())).export(Matchers.any(PdfDocument.class), Matchers.anyString());
        ImageDataUriContent imageDataUriContent = (ImageDataUriContent)contentArgumentCaptor.getValue();
        Assert.assertEquals((Object)JPG_DATA_URI, (Object)imageDataUriContent.getUri());
    }

    @Test
    public void testExportToPng() {
        Mockito.when((Object)this.canvasExport.toImageData((CanvasHandler)Matchers.eq((Object)this.canvasHandler), (Layer.URLDataType)Matchers.eq((Object)Layer.URLDataType.PNG))).thenReturn((Object)PNG_DATA_URI);
        this.tested.exportToPng(this.canvasHandler, "file1");
        ArgumentCaptor contentArgumentCaptor = ArgumentCaptor.forClass(ImageDataUriContent.class);
        ((FileExport)Mockito.verify(this.imageFileExport, (VerificationMode)Mockito.times((int)1))).export(contentArgumentCaptor.capture(), (String)Matchers.eq((Object)"file1.png"));
        ((FileExport)Mockito.verify(this.pdfFileExport, (VerificationMode)Mockito.never())).export(Matchers.any(PdfDocument.class), Matchers.anyString());
        ImageDataUriContent imageDataUriContent = (ImageDataUriContent)contentArgumentCaptor.getValue();
        Assert.assertEquals((Object)PNG_DATA_URI, (Object)imageDataUriContent.getUri());
    }

    @Test
    public void testExportToPdf() {
        Mockito.when((Object)this.canvasExport.toImageData((CanvasHandler)Matchers.eq((Object)this.canvasHandler), (Layer.URLDataType)Matchers.eq((Object)Layer.URLDataType.JPG))).thenReturn((Object)JPG_DATA_URI);
        ((FileExport)Mockito.verify(this.imageFileExport, (VerificationMode)Mockito.never())).export(Matchers.any(ImageDataUriContent.class), Matchers.anyString());
        this.tested.exportToPdf(this.canvasHandler, "file1");
        ((FileExport)Mockito.verify(this.pdfFileExport, (VerificationMode)Mockito.times((int)1))).export(Matchers.any(PdfDocument.class), (String)Matchers.eq((Object)"file1.pdf"));
    }
}

