/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.util;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.TestingGraphInstanceBuilder;
import org.kie.workbench.common.stunner.core.TestingGraphMockHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.view.BoundImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.BoundsImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CanvasLayoutUtilsTest {
    private static final double NEW_NODE_WIDTH = 100.0;
    private static final double NEW_NODE_HEIGHT = 100.0;
    private Point2D canvasMin;
    private Point2D canvasMax;
    private Point2D offset;
    @Mock
    private Diagram diagram;
    @Mock
    private Element parentCanvasRoot;
    @Mock
    private Element parentNotCanvasRoot;
    @Mock
    private DefinitionSet definitionSet;
    @Mock
    private Metadata metadata;
    @Mock
    private CanvasHandler canvasHandler;
    @Mock
    private Graph<DefinitionSet, Node> graph;
    @Mock
    private Bounds canvasBounds;
    @Mock
    private Bounds.Bound minCanvasBound;
    @Mock
    private Bounds.Bound maxCanvasBound;
    @Mock
    private Node<DefinitionSet, ?> nodeRoot;
    private CanvasLayoutUtils canvasLayoutUtils;
    private TestingGraphMockHandler graphTestHandler;
    private TestingGraphInstanceBuilder.TestGraph2 graphInstance;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.diagram.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.canvasHandler.getDiagram().getGraph()).thenReturn(this.graph);
        Mockito.when((Object)this.canvasHandler.getDiagram().getGraph().getNode("canvas_root")).thenReturn(this.nodeRoot);
        Mockito.when((Object)this.graph.getContent()).thenReturn((Object)this.definitionSet);
        Mockito.when((Object)((DefinitionSet)this.graph.getContent()).getBounds()).thenReturn((Object)this.canvasBounds);
        Mockito.when((Object)this.canvasHandler.getDiagram().getGraph().getNode("canvas_root")).thenReturn(this.nodeRoot);
        Mockito.when((Object)this.parentCanvasRoot.getUUID()).thenReturn((Object)"canvas_root");
        Mockito.when((Object)this.parentNotCanvasRoot.getUUID()).thenReturn((Object)"canvas_not_root");
        Mockito.when((Object)this.canvasBounds.getUpperLeft()).thenReturn((Object)this.minCanvasBound);
        Mockito.when((Object)this.canvasBounds.getLowerRight()).thenReturn((Object)this.maxCanvasBound);
        this.canvasMin = new Point2D(0.0, 0.0);
        Mockito.when((Object)this.minCanvasBound.getX()).thenReturn((Object)this.canvasMin.getX());
        Mockito.when((Object)this.minCanvasBound.getY()).thenReturn((Object)this.canvasMin.getY());
        this.canvasMax = new Point2D(1200.0, 1200.0);
        Mockito.when((Object)this.maxCanvasBound.getX()).thenReturn((Object)this.canvasMax.getX());
        Mockito.when((Object)this.maxCanvasBound.getY()).thenReturn((Object)this.canvasMax.getY());
        this.offset = new Point2D(100.0, 100.0);
        this.canvasLayoutUtils = new CanvasLayoutUtils();
    }

    @Test
    public void isCanvasRootTrueTest() {
        Mockito.when((Object)this.diagram.getMetadata().getCanvasRootUUID()).thenReturn((Object)"canvas_root");
        boolean isCanvasRoot = CanvasLayoutUtils.isCanvasRoot((Diagram)this.diagram, (Element)this.parentCanvasRoot);
        Assert.assertTrue((boolean)isCanvasRoot);
    }

    @Test
    public void isCanvasRootFalseTest() {
        Mockito.when((Object)this.diagram.getMetadata().getCanvasRootUUID()).thenReturn((Object)"test");
        boolean isCanvasRoot = CanvasLayoutUtils.isCanvasRoot((Diagram)this.diagram, (Element)this.parentNotCanvasRoot);
        Assert.assertFalse((boolean)isCanvasRoot);
    }

    @Test
    public void isCanvasRootWithUuidTrueTest() {
        Mockito.when((Object)this.diagram.getMetadata().getCanvasRootUUID()).thenReturn((Object)"canvas_root");
        boolean isCanvasRoot = CanvasLayoutUtils.isCanvasRoot((Diagram)this.diagram, (String)"canvas_root");
        Assert.assertTrue((boolean)isCanvasRoot);
    }

    @Test
    public void isCanvasRootWithUuidFalseTest() {
        Mockito.when((Object)this.diagram.getMetadata().getCanvasRootUUID()).thenReturn((Object)"test");
        boolean isCanvasRoot = CanvasLayoutUtils.isCanvasRoot((Diagram)this.diagram, (String)"canvas_root");
        Assert.assertFalse((boolean)isCanvasRoot);
    }

    @Test
    public void getNextWidthHeightTest() {
        Node node = (Node)Mockito.mock(Node.class);
        BoundsImpl bounds = new BoundsImpl(new BoundImpl(Double.valueOf(100.0), Double.valueOf(100.0)), new BoundImpl(Double.valueOf(300.0), Double.valueOf(200.0)));
        ArrayList<Node> nodes = new ArrayList<Node>();
        View view = (View)Mockito.mock(View.class);
        Mockito.when((Object)node.getContent()).thenReturn((Object)view);
        Mockito.when((Object)view.getBounds()).thenReturn((Object)bounds);
        nodes.add(node);
        Mockito.when((Object)this.graph.nodes()).thenReturn(nodes);
        double[] next = this.canvasLayoutUtils.getNext(this.canvasHandler, 100.0);
        double x = next[0];
        double y = next[1];
        Assert.assertTrue((x > 100.0 ? 1 : 0) != 0);
        Assert.assertTrue((y > 100.0 ? 1 : 0) != 0);
    }

    @Test
    public void getNextOffsetTest() {
        Node node = (Node)Mockito.mock(Node.class);
        BoundsImpl bounds = new BoundsImpl(new BoundImpl(Double.valueOf(100.0), Double.valueOf(100.0)), new BoundImpl(Double.valueOf(300.0), Double.valueOf(200.0)));
        ArrayList<Node> nodes = new ArrayList<Node>();
        View view = (View)Mockito.mock(View.class);
        Mockito.when((Object)node.getContent()).thenReturn((Object)view);
        Mockito.when((Object)view.getBounds()).thenReturn((Object)bounds);
        nodes.add(node);
        Mockito.when((Object)this.graph.nodes()).thenReturn(nodes);
        double[] next = this.canvasLayoutUtils.getNext(this.canvasHandler, 100.0, this.offset);
        double nextX = next[0];
        double nextY = next[1];
        Assert.assertTrue((nextX > 100.0 + this.offset.getX() ? 1 : 0) != 0);
        Assert.assertTrue((nextY > 100.0 + this.offset.getY() ? 1 : 0) != 0);
    }

    @Test
    public void getNextOffsetAndMin() {
        Node node = (Node)Mockito.mock(Node.class);
        BoundsImpl bounds = new BoundsImpl(new BoundImpl(Double.valueOf(100.0), Double.valueOf(100.0)), new BoundImpl(Double.valueOf(300.0), Double.valueOf(200.0)));
        ArrayList<Node> nodes = new ArrayList<Node>();
        View view = (View)Mockito.mock(View.class);
        Mockito.when((Object)node.getContent()).thenReturn((Object)view);
        Mockito.when((Object)view.getBounds()).thenReturn((Object)bounds);
        nodes.add(node);
        Mockito.when((Object)this.graph.nodes()).thenReturn(nodes);
        Point2D min = new Point2D(this.canvasMin.getX(), this.canvasMin.getY());
        double[] next = this.canvasLayoutUtils.getNext(this.canvasHandler, 100.0, this.offset, min);
        double nextX = next[0];
        double nextY = next[1];
        Assert.assertTrue((nextX > 100.0 + this.offset.getX() ? 1 : 0) != 0);
        Assert.assertTrue((nextY > 100.0 + this.offset.getY() ? 1 : 0) != 0);
    }

    @Test
    public void getNextFromRoot() {
        Node node1 = (Node)Mockito.mock(Node.class);
        BoundsImpl boundsNode1 = new BoundsImpl(new BoundImpl(Double.valueOf(100.0), Double.valueOf(100.0)), new BoundImpl(Double.valueOf(300.0), Double.valueOf(200.0)));
        View viewNode1 = (View)Mockito.mock(View.class);
        Mockito.when((Object)node1.getContent()).thenReturn((Object)viewNode1);
        Mockito.when((Object)viewNode1.getBounds()).thenReturn((Object)boundsNode1);
        Node node2 = (Node)Mockito.mock(Node.class);
        BoundsImpl boundsNode2 = new BoundsImpl(new BoundImpl(Double.valueOf(100.0), Double.valueOf(100.0)), new BoundImpl(Double.valueOf(300.0), Double.valueOf(200.0)));
        View viewNode2 = (View)Mockito.mock(View.class);
        Mockito.when((Object)node2.getContent()).thenReturn((Object)viewNode2);
        Mockito.when((Object)viewNode2.getBounds()).thenReturn((Object)boundsNode2);
        Node nodeRoot = (Node)Mockito.mock(Node.class);
        double rootWidth = 40.0;
        double rootHeight = 40.0;
        BoundsImpl rootBounds = new BoundsImpl(new BoundImpl(Double.valueOf(0.0), Double.valueOf(0.0)), new BoundImpl(Double.valueOf(rootWidth), Double.valueOf(rootHeight)));
        View rootView = (View)Mockito.mock(View.class);
        Mockito.when((Object)nodeRoot.getContent()).thenReturn((Object)rootView);
        Mockito.when((Object)rootView.getBounds()).thenReturn((Object)rootBounds);
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        Edge edge = (Edge)Mockito.mock(Edge.class);
        edges.add(edge);
        Mockito.when((Object)nodeRoot.getOutEdges()).thenReturn(edges);
        Mockito.when((Object)edge.getTargetNode()).thenReturn((Object)node1);
        Mockito.when((Object)nodeRoot.getContent()).thenReturn((Object)rootView);
        nodes.add(nodeRoot);
        Mockito.when((Object)this.graph.nodes()).thenReturn(nodes);
        double[] next = this.canvasLayoutUtils.getNext(this.canvasHandler, nodeRoot, node2);
        double nextX = next[0];
        double nextY = next[1];
        Assert.assertTrue((nextX > rootWidth ? 1 : 0) != 0);
        Assert.assertTrue((nextY > 100.0 ? 1 : 0) != 0);
    }

    @Test
    public void getNextFromRootWithParent() {
        this.graphTestHandler = new TestingGraphMockHandler();
        this.graphInstance = TestingGraphInstanceBuilder.newGraph2((TestingGraphMockHandler)this.graphTestHandler);
        Node node = (Node)Mockito.mock(Node.class);
        BoundsImpl boundsNode = new BoundsImpl(new BoundImpl(Double.valueOf(100.0), Double.valueOf(100.0)), new BoundImpl(Double.valueOf(300.0), Double.valueOf(200.0)));
        View viewNode = (View)Mockito.mock(View.class);
        Mockito.when((Object)node.getContent()).thenReturn((Object)viewNode);
        Mockito.when((Object)viewNode.getBounds()).thenReturn((Object)boundsNode);
        Mockito.when((Object)this.canvasHandler.getDiagram().getGraph()).thenReturn((Object)this.graphInstance.graph);
        double[] next = this.canvasLayoutUtils.getNext(this.canvasHandler, this.graphInstance.startNode, node);
        Node start = this.graphInstance.startNode;
        double[] size = GraphUtils.getNodeSize((View)((View)start.getContent()));
        double nextX = next[0];
        double nextY = next[1];
        Assert.assertTrue((nextX > size[0] ? 1 : 0) != 0);
        Assert.assertTrue((nextY > size[1] ? 1 : 0) != 0);
    }
}

