/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.command;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.api.AbstractClientSessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.AbstractSessionCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientFullSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandListener;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.HasCommandListener;
import org.kie.workbench.common.stunner.core.command.exception.CommandException;
import org.kie.workbench.common.stunner.core.registry.command.CommandRegistry;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultSessionCommandManagerTest {
    @Mock
    AbstractClientSessionManager clientSessionManager;
    @Mock
    AbstractCanvasHandler canvasHandler;
    @Mock
    AbstractClientFullSession clientFullSession;
    @Mock
    Command<AbstractCanvasHandler, CanvasViolation> command;
    @Mock
    CommandListener<AbstractCanvasHandler, CanvasViolation> commandListener;
    @Mock
    CommandRegistry<Command<AbstractCanvasHandler, CanvasViolation>> commandRegistry;
    private SessionCommandManagerStub tested;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.clientSessionManager.getCurrentSession()).thenReturn((Object)this.clientFullSession);
        Mockito.when((Object)this.clientFullSession.getCommandRegistry()).thenReturn(this.commandRegistry);
    }

    @Test
    public void testExecuteSuccess() {
        SuccessCanvasCommandManager commandManager = new SuccessCanvasCommandManager();
        Mockito.when((Object)this.clientFullSession.getCommandManager()).thenReturn((Object)commandManager);
        this.tested = new SessionCommandManagerStub();
        CommandResult result = this.tested.execute(this.canvasHandler, (Command)Mockito.mock(Command.class));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)CommandResult.Type.INFO, (Object)result.getType());
        Assert.assertEquals(this.commandListener, (Object)commandManager.listener);
        ((AbstractClientSessionManager)Mockito.verify((Object)this.clientSessionManager, (VerificationMode)Mockito.times((int)0))).handleClientError((ClientRuntimeError)Mockito.any(ClientRuntimeError.class));
        ((AbstractClientSessionManager)Mockito.verify((Object)this.clientSessionManager, (VerificationMode)Mockito.times((int)0))).handleCommandError((CommandException)Mockito.any(CommandException.class));
    }

    @Test
    public void testExecuteCommandException() {
        CommandExceptionCanvasCommandManager commandManager = new CommandExceptionCanvasCommandManager();
        Mockito.when((Object)this.clientFullSession.getCommandManager()).thenReturn((Object)commandManager);
        this.tested = new SessionCommandManagerStub();
        CommandResult result = this.tested.execute(this.canvasHandler, (Command)Mockito.mock(Command.class));
        Assert.assertEquals(this.commandListener, (Object)commandManager.listener);
        ((AbstractClientSessionManager)Mockito.verify((Object)this.clientSessionManager, (VerificationMode)Mockito.times((int)0))).handleClientError((ClientRuntimeError)Mockito.any(ClientRuntimeError.class));
        ((AbstractClientSessionManager)Mockito.verify((Object)this.clientSessionManager, (VerificationMode)Mockito.times((int)1))).handleCommandError((CommandException)Mockito.any(CommandException.class));
    }

    @Test
    public void testExecuteClientError() {
        RuntimeExceptionCanvasCommandManager commandManager = new RuntimeExceptionCanvasCommandManager();
        Mockito.when((Object)this.clientFullSession.getCommandManager()).thenReturn((Object)commandManager);
        this.tested = new SessionCommandManagerStub();
        this.tested.execute(this.canvasHandler, (Command)Mockito.mock(Command.class));
        Assert.assertEquals(this.commandListener, (Object)commandManager.listener);
        ((AbstractClientSessionManager)Mockito.verify((Object)this.clientSessionManager, (VerificationMode)Mockito.times((int)1))).handleClientError((ClientRuntimeError)Mockito.any(ClientRuntimeError.class));
        ((AbstractClientSessionManager)Mockito.verify((Object)this.clientSessionManager, (VerificationMode)Mockito.times((int)0))).handleCommandError((CommandException)Mockito.any(CommandException.class));
    }

    @Test
    public void testUndoSuccess() {
        SuccessCanvasCommandManager commandManager = new SuccessCanvasCommandManager();
        Mockito.when((Object)this.clientFullSession.getCommandManager()).thenReturn((Object)commandManager);
        this.tested = new SessionCommandManagerStub();
        CommandResult result = this.tested.undo(this.canvasHandler, (Command)Mockito.mock(Command.class));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)CommandResult.Type.INFO, (Object)result.getType());
        Assert.assertEquals(this.commandListener, (Object)commandManager.listener);
        ((AbstractClientSessionManager)Mockito.verify((Object)this.clientSessionManager, (VerificationMode)Mockito.times((int)0))).handleClientError((ClientRuntimeError)Mockito.any(ClientRuntimeError.class));
        ((AbstractClientSessionManager)Mockito.verify((Object)this.clientSessionManager, (VerificationMode)Mockito.times((int)0))).handleCommandError((CommandException)Mockito.any(CommandException.class));
    }

    @Test(expected=CommandException.class)
    public void testUndoCommandException() {
        CommandExceptionCanvasCommandManager commandManager = new CommandExceptionCanvasCommandManager();
        Mockito.when((Object)this.clientFullSession.getCommandManager()).thenReturn((Object)commandManager);
        this.tested = new SessionCommandManagerStub();
        this.tested.undo(this.canvasHandler, (Command)Mockito.mock(Command.class));
        Assert.assertEquals(this.commandListener, (Object)commandManager.listener);
        ((AbstractClientSessionManager)Mockito.verify((Object)this.clientSessionManager, (VerificationMode)Mockito.times((int)0))).handleClientError((ClientRuntimeError)Mockito.any(ClientRuntimeError.class));
        ((AbstractClientSessionManager)Mockito.verify((Object)this.clientSessionManager, (VerificationMode)Mockito.times((int)1))).handleCommandError((CommandException)Mockito.any(CommandException.class));
    }

    @Test(expected=RuntimeException.class)
    public void testUndoClientError() {
        RuntimeExceptionCanvasCommandManager commandManager = new RuntimeExceptionCanvasCommandManager();
        Mockito.when((Object)this.clientFullSession.getCommandManager()).thenReturn((Object)commandManager);
        this.tested = new SessionCommandManagerStub();
        this.tested.undo(this.canvasHandler, (Command)Mockito.mock(Command.class));
        Assert.assertEquals(this.commandListener, (Object)commandManager.listener);
        ((AbstractClientSessionManager)Mockito.verify((Object)this.clientSessionManager, (VerificationMode)Mockito.times((int)1))).handleClientError((ClientRuntimeError)Mockito.any(ClientRuntimeError.class));
        ((AbstractClientSessionManager)Mockito.verify((Object)this.clientSessionManager, (VerificationMode)Mockito.times((int)0))).handleCommandError((CommandException)Mockito.any(CommandException.class));
    }

    private abstract class CanvasCommandManagerStub
    implements CanvasCommandManager<AbstractCanvasHandler>,
    HasCommandListener<CommandListener<AbstractCanvasHandler, CanvasViolation>> {
        CommandListener<AbstractCanvasHandler, CanvasViolation> listener;

        private CanvasCommandManagerStub() {
        }

        protected abstract CommandResult<CanvasViolation> getResult();

        public CommandResult<CanvasViolation> allow(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command) {
            return this.getResult();
        }

        public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command) {
            return this.getResult();
        }

        public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command) {
            return this.getResult();
        }

        public void setCommandListener(CommandListener<AbstractCanvasHandler, CanvasViolation> listener) {
            this.listener = listener;
        }
    }

    private class RuntimeExceptionCanvasCommandManager
    extends CanvasCommandManagerStub {
        private RuntimeExceptionCanvasCommandManager() {
        }

        @Override
        protected CommandResult<CanvasViolation> getResult() {
            throw new RuntimeException();
        }
    }

    private class CommandExceptionCanvasCommandManager
    extends CanvasCommandManagerStub {
        private CommandExceptionCanvasCommandManager() {
        }

        @Override
        protected CommandResult<CanvasViolation> getResult() {
            throw new CommandException(DefaultSessionCommandManagerTest.this.command);
        }
    }

    private class SuccessCanvasCommandManager
    extends CanvasCommandManagerStub {
        private SuccessCanvasCommandManager() {
        }

        @Override
        protected CommandResult<CanvasViolation> getResult() {
            return CanvasCommandResultBuilder.SUCCESS;
        }
    }

    private class SessionCommandManagerStub
    extends AbstractSessionCommandManager {
        private SessionCommandManagerStub() {
        }

        protected AbstractClientSessionManager getClientSessionManager() {
            return DefaultSessionCommandManagerTest.this.clientSessionManager;
        }

        protected CommandListener<AbstractCanvasHandler, CanvasViolation> getRegistryListener() {
            return DefaultSessionCommandManagerTest.this.commandListener;
        }
    }
}

