/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.command;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.api.AbstractClientSessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.mouse.CanvasMouseDownEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.mouse.CanvasMouseUpEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManagerImpl;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.RequestCommandManager;
import org.kie.workbench.common.stunner.core.client.session.ClientFullSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CompositeCommand;
import org.kie.workbench.common.stunner.core.registry.command.CommandRegistry;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RequestCommandManagerTest {
    @Mock
    AbstractClientSessionManager clientSessionManager;
    @Mock
    AbstractCanvasHandler canvasHandler;
    @Mock
    AbstractCanvas canvas;
    @Mock
    ClientFullSession clientFullSession;
    @Mock
    Command<AbstractCanvasHandler, CanvasViolation> command;
    @Mock
    Command<AbstractCanvasHandler, CanvasViolation> command1;
    @Mock
    Command<AbstractCanvasHandler, CanvasViolation> command2;
    @Mock
    CommandRegistry<Command<AbstractCanvasHandler, CanvasViolation>> commandRegistry;
    @Mock
    CanvasMouseDownEvent mouseDownEvent;
    @Mock
    CanvasMouseUpEvent mouseUpEvent;
    private RequestCommandManager tested;
    private CanvasCommandManagerImpl commandManager;

    @Before
    public void setup() throws Exception {
        this.commandManager = new CanvasCommandManagerImpl();
        Mockito.when((Object)this.canvasHandler.getCanvas()).thenReturn((Object)this.canvas);
        Mockito.when((Object)this.clientSessionManager.getCurrentSession()).thenReturn((Object)this.clientFullSession);
        Mockito.when((Object)this.clientFullSession.getCommandRegistry()).thenReturn(this.commandRegistry);
        Mockito.when((Object)this.clientFullSession.getCommandManager()).thenReturn((Object)this.commandManager);
        this.tested = new RequestCommandManager(this.clientSessionManager);
    }

    @Test
    public void testSingleExecuteSuccess() {
        Mockito.when((Object)this.command.execute(Matchers.eq((Object)this.canvasHandler))).thenReturn((Object)CanvasCommandResultBuilder.SUCCESS);
        this.tested.onCanvasMouseDownEvent(this.mouseDownEvent);
        this.tested.execute(this.canvasHandler, this.command);
        this.tested.onCanvasMouseUpEvent(this.mouseUpEvent);
        ArgumentCaptor commandArgumentCaptor = ArgumentCaptor.forClass(Command.class);
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)1))).register((Command)commandArgumentCaptor.capture());
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).peek();
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).pop();
        this.assertCompositeCommand((Command)commandArgumentCaptor.getValue(), 1);
    }

    @Test
    public void testMultipleExecuteSuccess() {
        Mockito.when((Object)this.command.execute(Matchers.eq((Object)this.canvasHandler))).thenReturn((Object)CanvasCommandResultBuilder.SUCCESS);
        Mockito.when((Object)this.command1.execute(Matchers.eq((Object)this.canvasHandler))).thenReturn((Object)CanvasCommandResultBuilder.SUCCESS);
        Mockito.when((Object)this.command2.execute(Matchers.eq((Object)this.canvasHandler))).thenReturn((Object)CanvasCommandResultBuilder.SUCCESS);
        this.tested.onCanvasMouseDownEvent(this.mouseDownEvent);
        this.tested.execute(this.canvasHandler, this.command);
        this.tested.execute(this.canvasHandler, this.command1);
        this.tested.execute(this.canvasHandler, this.command2);
        this.tested.onCanvasMouseUpEvent(this.mouseUpEvent);
        ArgumentCaptor commandArgumentCaptor = ArgumentCaptor.forClass(Command.class);
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)1))).register((Command)commandArgumentCaptor.capture());
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).peek();
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).pop();
        this.assertCompositeCommand((Command)commandArgumentCaptor.getValue(), 3);
    }

    @Test
    public void testSingleExecuteFailed() {
        Mockito.when((Object)this.command.execute(Matchers.eq((Object)this.canvasHandler))).thenReturn((Object)CanvasCommandResultBuilder.FAILED);
        this.tested.onCanvasMouseDownEvent(this.mouseDownEvent);
        this.tested.execute(this.canvasHandler, this.command);
        this.tested.onCanvasMouseUpEvent(this.mouseUpEvent);
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).register(this.command);
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).peek();
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).pop();
    }

    @Test
    public void testSingleUndoSuccess() {
        Mockito.when((Object)this.command.undo(Matchers.eq((Object)this.canvasHandler))).thenReturn((Object)CanvasCommandResultBuilder.SUCCESS);
        this.tested.onCanvasMouseDownEvent(this.mouseDownEvent);
        this.tested.undo((Object)this.canvasHandler, this.command);
        this.tested.onCanvasMouseUpEvent(this.mouseUpEvent);
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)1))).pop();
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).register(this.command);
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).peek();
    }

    @Test
    public void testSingleUndoFailed() {
        Mockito.when((Object)this.command.undo(Matchers.eq((Object)this.canvasHandler))).thenReturn((Object)CanvasCommandResultBuilder.FAILED);
        this.tested.onCanvasMouseDownEvent(this.mouseDownEvent);
        this.tested.undo((Object)this.canvasHandler, this.command);
        this.tested.onCanvasMouseUpEvent(this.mouseUpEvent);
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).pop();
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).register(this.command);
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).peek();
    }

    @Test
    public void testNoRequestComleted() {
        Mockito.when((Object)this.command.execute(Matchers.eq((Object)this.canvasHandler))).thenReturn((Object)CanvasCommandResultBuilder.SUCCESS);
        this.tested.onCanvasMouseDownEvent(this.mouseDownEvent);
        this.tested.execute(this.canvasHandler, this.command);
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).register((Command)Mockito.any(Command.class));
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).peek();
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).pop();
    }

    private void assertCompositeCommand(Command captured, int size) {
        Assert.assertNotNull((Object)captured);
        Assert.assertTrue((boolean)(captured instanceof CompositeCommand));
        Assert.assertEquals((long)size, (long)((CompositeCommand)captured).size());
    }
}

