/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.command;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.api.AbstractClientSessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManagerImpl;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManagerImpl;
import org.kie.workbench.common.stunner.core.client.session.ClientFullSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.registry.command.CommandRegistry;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SessionCommandManagerTest {
    @Mock
    AbstractClientSessionManager clientSessionManager;
    @Mock
    AbstractCanvasHandler canvasHandler;
    @Mock
    AbstractCanvas canvas;
    @Mock
    ClientFullSession clientFullSession;
    @Mock
    Command<AbstractCanvasHandler, CanvasViolation> command;
    @Mock
    CommandRegistry<Command<AbstractCanvasHandler, CanvasViolation>> commandRegistry;
    private SessionCommandManagerImpl tested;
    private CanvasCommandManagerImpl commandManager;

    @Before
    public void setup() throws Exception {
        this.commandManager = new CanvasCommandManagerImpl();
        Mockito.when((Object)this.canvasHandler.getCanvas()).thenReturn((Object)this.canvas);
        Mockito.when((Object)this.clientSessionManager.getCurrentSession()).thenReturn((Object)this.clientFullSession);
        Mockito.when((Object)this.clientFullSession.getCommandRegistry()).thenReturn(this.commandRegistry);
        Mockito.when((Object)this.clientFullSession.getCommandManager()).thenReturn((Object)this.commandManager);
        this.tested = new SessionCommandManagerImpl(this.clientSessionManager);
    }

    @Test
    public void testExecuteSuccess() {
        Mockito.when((Object)this.command.execute(Matchers.eq((Object)this.canvasHandler))).thenReturn((Object)CanvasCommandResultBuilder.SUCCESS);
        this.tested.execute(this.canvasHandler, this.command);
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)1))).register(this.command);
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).peek();
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).pop();
    }

    @Test
    public void testExecuteFailed() {
        Mockito.when((Object)this.command.execute(Matchers.eq((Object)this.canvasHandler))).thenReturn((Object)CanvasCommandResultBuilder.FAILED);
        this.tested.execute(this.canvasHandler, this.command);
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).register(this.command);
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).peek();
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).pop();
    }

    @Test
    public void testUndoSuccess() {
        Mockito.when((Object)this.command.undo(Matchers.eq((Object)this.canvasHandler))).thenReturn((Object)CanvasCommandResultBuilder.SUCCESS);
        this.tested.undo((Object)this.canvasHandler, this.command);
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)1))).pop();
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).register(this.command);
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).peek();
    }

    @Test
    public void testUndoFailed() {
        Mockito.when((Object)this.command.undo(Matchers.eq((Object)this.canvasHandler))).thenReturn((Object)CanvasCommandResultBuilder.FAILED);
        this.tested.undo((Object)this.canvasHandler, this.command);
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).pop();
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).register(this.command);
        ((CommandRegistry)Mockito.verify(this.commandRegistry, (VerificationMode)Mockito.times((int)0))).peek();
    }
}

