/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.palette.model.definition.impl;

import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.components.palette.model.PaletteDefinitionBuilder;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionPaletteCategory;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionSetPalette;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.impl.DefinitionSetPaletteBuilderImpl;
import org.kie.workbench.common.stunner.core.client.service.ClientFactoryService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefinitionSetPaletteBuilderImplTest {
    private static final String DEFINITION_SET_ID = "definitionSetId";
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private ClientFactoryService clientFactoryServices;
    @Mock
    private DefinitionManager definitionManager;
    @Mock
    private AdapterManager adapterManager;
    @Mock
    private DefinitionAdapter definitionAdapter;
    private Set<String> definitionIds = new HashSet<String>();
    private PaletteDefinitionBuilder.Configuration configuration;
    private PaletteDefinitionBuilder.Callback<DefinitionSetPalette, ClientRuntimeError> callback;
    private Object defId1 = new Object();
    private Object defId2 = new Object();
    private Object defId3 = new Object();
    private DefinitionSetPalette paletteDefinition;
    private DefinitionSetPaletteBuilderImpl paletteBuilder;

    @Before
    public void setup() {
        this.paletteBuilder = new DefinitionSetPaletteBuilderImpl(this.definitionUtils, this.clientFactoryServices);
        this.definitionIds.add("id1");
        this.definitionIds.add("id2");
        this.definitionIds.add("id3");
        this.configuration = new PaletteDefinitionBuilder.Configuration(){

            public String getDefinitionSetId() {
                return DefinitionSetPaletteBuilderImplTest.DEFINITION_SET_ID;
            }

            public Set<String> getDefinitionIds() {
                return DefinitionSetPaletteBuilderImplTest.this.definitionIds;
            }
        };
        this.callback = new PaletteDefinitionBuilder.Callback<DefinitionSetPalette, ClientRuntimeError>(){

            public void onSuccess(DefinitionSetPalette paletteDefinition) {
                DefinitionSetPaletteBuilderImplTest.this.paletteDefinition = paletteDefinition;
            }

            public void onError(ClientRuntimeError error) {
                Assert.fail((String)error.getMessage());
            }
        };
        ((ClientFactoryService)Mockito.doAnswer(invocation -> {
            String id = (String)invocation.getArguments()[0];
            ServiceCallback callback = (ServiceCallback)invocation.getArguments()[1];
            if (id.equals("id1")) {
                callback.onSuccess(this.defId1);
            } else if (id.equals("id2")) {
                callback.onSuccess(this.defId2);
            } else if (id.equals("id3")) {
                callback.onSuccess(this.defId3);
            } else {
                callback.onError(new ClientRuntimeError("Not found"));
            }
            return null;
        }).when((Object)this.clientFactoryServices)).newDefinition(Matchers.anyString(), (ServiceCallback)Matchers.any(ServiceCallback.class));
        Mockito.when((Object)this.definitionUtils.getDefinitionManager()).thenReturn((Object)this.definitionManager);
        Mockito.when((Object)this.definitionManager.adapters()).thenReturn((Object)this.adapterManager);
        Mockito.when((Object)this.adapterManager.forDefinition()).thenReturn((Object)this.definitionAdapter);
        ((DefinitionAdapter)Mockito.doAnswer(invocation -> {
            Object o = invocation.getArguments()[0];
            if (o == this.defId1) {
                return "id1";
            }
            if (o == this.defId2) {
                return "id2";
            }
            if (o == this.defId3) {
                return "id3";
            }
            return null;
        }).when((Object)this.definitionAdapter)).getId(Mockito.anyObject());
        ((DefinitionAdapter)Mockito.doAnswer(invocation -> {
            Object o = invocation.getArguments()[0];
            if (o == this.defId1) {
                return "category1";
            }
            if (o == this.defId2) {
                return "category2";
            }
            if (o == this.defId3) {
                return "category2";
            }
            return null;
        }).when((Object)this.definitionAdapter)).getCategory(Mockito.anyObject());
        ((DefinitionAdapter)Mockito.doAnswer(invocation -> {
            Object o = invocation.getArguments()[0];
            if (o == this.defId1) {
                return "defId1-title";
            }
            if (o == this.defId2) {
                return "defId2-title";
            }
            if (o == this.defId3) {
                return "defId3-title";
            }
            return null;
        }).when((Object)this.definitionAdapter)).getTitle(Mockito.anyObject());
        ((DefinitionAdapter)Mockito.doAnswer(invocation -> {
            Object o = invocation.getArguments()[0];
            if (o == this.defId1) {
                return "defId1-description";
            }
            if (o == this.defId2) {
                return "defId2-description";
            }
            if (o == this.defId3) {
                return "defId3-description";
            }
            return null;
        }).when((Object)this.definitionAdapter)).getDescription(Mockito.anyObject());
    }

    @Test
    public void checkBuildWithNoExclusions() {
        this.paletteBuilder.build(this.configuration, this.callback);
        Assert.assertNotNull((Object)this.paletteDefinition);
        Assert.assertEquals((long)2L, (long)this.paletteDefinition.getItems().size());
        DefinitionPaletteCategory category1 = this.assertPaletteContainsCategory("category1");
        DefinitionPaletteCategory category2 = this.assertPaletteContainsCategory("category2");
        this.assertPaletteCategoryContains(category1, "id1");
        this.assertPaletteCategoryContains(category2, "id2");
        this.assertPaletteCategoryContains(category2, "id3");
    }

    @Test
    public void checkBuildWithCategoryExclusion() {
        this.paletteBuilder.excludeCategory("category1");
        this.paletteBuilder.build(this.configuration, this.callback);
        Assert.assertNotNull((Object)this.paletteDefinition);
        Assert.assertEquals((long)1L, (long)this.paletteDefinition.getItems().size());
        DefinitionPaletteCategory category2 = this.assertPaletteContainsCategory("category2");
        this.assertPaletteCategoryContains(category2, "id2");
        this.assertPaletteCategoryContains(category2, "id3");
    }

    @Test
    public void checkBuildWithDefinitionExclusion() {
        this.paletteBuilder.excludeDefinition("id3");
        this.paletteBuilder.build(this.configuration, this.callback);
        Assert.assertNotNull((Object)this.paletteDefinition);
        Assert.assertEquals((long)2L, (long)this.paletteDefinition.getItems().size());
        DefinitionPaletteCategory category1 = this.assertPaletteContainsCategory("category1");
        DefinitionPaletteCategory category2 = this.assertPaletteContainsCategory("category2");
        this.assertPaletteCategoryContains(category1, "id1");
        this.assertPaletteCategoryContains(category2, "id2");
    }

    private DefinitionPaletteCategory assertPaletteContainsCategory(String category) {
        return this.paletteDefinition.getItems().stream().filter(c -> c.getTitle().equals(category)).findFirst().orElseThrow(() -> new RuntimeException("Not found"));
    }

    private void assertPaletteCategoryContains(DefinitionPaletteCategory category, String itemId) {
        Assert.assertTrue((boolean)category.getItems().stream().filter(i -> i.getId().equals(itemId)).findFirst().isPresent());
    }
}

