/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.views;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Layer;
import org.kie.workbench.common.stunner.core.client.canvas.Transform;
import org.kie.workbench.common.stunner.core.client.components.views.CanvasDefinitionTooltip;
import org.kie.workbench.common.stunner.core.client.components.views.CanvasTooltip;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class CanvasDefinitionTooltipTest {
    @Mock
    private CanvasTooltip<String> textTooltip;
    private CanvasDefinitionTooltip tested;

    @Before
    public void setup() throws Exception {
        this.tested = new CanvasDefinitionTooltip(this.textTooltip, defId -> defId + "theTestTitle");
    }

    @Test
    public void testSetCanvasLocation() {
        Point2D point = new Point2D(22.0, 66.0);
        this.tested.setCanvasLocation(point);
        ((CanvasTooltip)Mockito.verify(this.textTooltip, (VerificationMode)Mockito.times((int)1))).setCanvasLocation((Point2D)Matchers.eq((Object)point));
    }

    @Test
    public void testSetTransform() {
        Transform transform = (Transform)Mockito.mock(Transform.class);
        this.tested.setTransform(transform);
        ((CanvasTooltip)Mockito.verify(this.textTooltip, (VerificationMode)Mockito.times((int)1))).setTransform((Transform)Matchers.eq((Object)transform));
    }

    @Test
    public void testConfigure() {
        AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        AbstractCanvas canvas = (AbstractCanvas)Mockito.mock(AbstractCanvas.class);
        AbstractCanvas.View canvasView = (AbstractCanvas.View)Mockito.mock(AbstractCanvas.View.class);
        Layer layer = (Layer)Mockito.mock(Layer.class);
        Transform transform = (Transform)Mockito.mock(Transform.class);
        Mockito.when((Object)canvasHandler.getCanvas()).thenReturn((Object)canvas);
        Mockito.when((Object)canvasHandler.getAbstractCanvas()).thenReturn((Object)canvas);
        Mockito.when((Object)canvas.getLayer()).thenReturn((Object)layer);
        Mockito.when((Object)layer.getTransform()).thenReturn((Object)transform);
        Mockito.when((Object)canvas.getView()).thenReturn((Object)canvasView);
        Mockito.when((Object)canvasView.getAbsoluteX()).thenReturn((Object)220.0);
        Mockito.when((Object)canvasView.getAbsoluteY()).thenReturn((Object)50.5);
        CanvasDefinitionTooltip t = this.tested.configure(canvasHandler);
        Assert.assertEquals((Object)this.tested, (Object)t);
        ((CanvasTooltip)Mockito.verify(this.textTooltip, (VerificationMode)Mockito.times((int)1))).setTransform((Transform)Matchers.eq((Object)transform));
        ArgumentCaptor pointCaptor = ArgumentCaptor.forClass(Point2D.class);
        ((CanvasTooltip)Mockito.verify(this.textTooltip, (VerificationMode)Mockito.times((int)1))).setCanvasLocation((Point2D)pointCaptor.capture());
        Point2D point = (Point2D)pointCaptor.getValue();
        Assert.assertEquals((double)220.0, (double)point.getX(), (double)0.0);
        Assert.assertEquals((double)50.5, (double)point.getY(), (double)0.0);
    }

    @Test
    public void testShow() {
        Point2D point = new Point2D(55.0, 6.0);
        this.tested.show(new CanvasDefinitionTooltip.DefinitionIdContent("def1"), point);
        ((CanvasTooltip)Mockito.verify(this.textTooltip, (VerificationMode)Mockito.times((int)1))).show(Matchers.eq((Object)"def1theTestTitle"), (Point2D)Matchers.eq((Object)point));
        ((CanvasTooltip)Mockito.verify(this.textTooltip, (VerificationMode)Mockito.never())).hide();
        ((CanvasTooltip)Mockito.verify(this.textTooltip, (VerificationMode)Mockito.never())).destroy();
    }

    @Test
    public void testShowById() {
        Point2D point = new Point2D(55.0, 6.0);
        this.tested.show("def1", point);
        ((CanvasTooltip)Mockito.verify(this.textTooltip, (VerificationMode)Mockito.times((int)1))).show(Matchers.eq((Object)"def1theTestTitle"), (Point2D)Matchers.eq((Object)point));
        ((CanvasTooltip)Mockito.verify(this.textTooltip, (VerificationMode)Mockito.never())).hide();
        ((CanvasTooltip)Mockito.verify(this.textTooltip, (VerificationMode)Mockito.never())).destroy();
    }

    @Test
    public void testHide() {
        this.tested.hide();
        ((CanvasTooltip)Mockito.verify(this.textTooltip, (VerificationMode)Mockito.times((int)1))).hide();
        ((CanvasTooltip)Mockito.verify(this.textTooltip, (VerificationMode)Mockito.never())).show((Object)Matchers.anyString(), (Point2D)Matchers.any(Point2D.class));
    }

    @Test
    public void testDsetroy() {
        this.tested.destroy();
        ((CanvasTooltip)Mockito.verify(this.textTooltip, (VerificationMode)Mockito.times((int)1))).destroy();
        ((CanvasTooltip)Mockito.verify(this.textTooltip, (VerificationMode)Mockito.never())).show((Object)Matchers.anyString(), (Point2D)Matchers.any(Point2D.class));
    }
}

