/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.event.keyboard;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.event.keyboard.ClientKeyShortcutsHandler;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.event.keyboard.SessionKeyShortcutsHandler;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SessionKeyShortcutsHandlerTest {
    @Mock
    private ClientKeyShortcutsHandler clientKeyShortcutsHandler;
    @Mock
    private SessionManager clientSessionManager;
    @Mock
    private ClientSession session;
    private SessionKeyShortcutsHandler tested;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.clientSessionManager.getCurrentSession()).thenReturn((Object)this.session);
        this.tested = new SessionKeyShortcutsHandler(this.clientSessionManager, this.clientKeyShortcutsHandler);
    }

    @Test
    public void testCallbacksWithBindUnbindSession() {
        SessionKeyShortcutsHandler.SessionKeyShortcutCallback[] sessionCallback = new SessionKeyShortcutsHandler.SessionKeyShortcutCallback[1];
        ((ClientKeyShortcutsHandler)Mockito.doAnswer(invocationOnMock -> {
            sessionCallback[0] = (SessionKeyShortcutsHandler.SessionKeyShortcutCallback)invocationOnMock.getArguments()[0];
            return null;
        }).when((Object)this.clientKeyShortcutsHandler)).setKeyShortcutCallback((ClientKeyShortcutsHandler.KeyShortcutCallback)Mockito.any(ClientKeyShortcutsHandler.KeyShortcutCallback.class));
        ClientKeyShortcutsHandler.KeyShortcutCallback callback = (ClientKeyShortcutsHandler.KeyShortcutCallback)Mockito.mock(ClientKeyShortcutsHandler.KeyShortcutCallback.class);
        this.tested.setKeyShortcutCallback(callback);
        Assert.assertEquals((Object)callback, (Object)sessionCallback[0].getDelegate());
        ((ClientKeyShortcutsHandler.KeyShortcutCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).onKeyShortcut(new KeyboardEvent.Key[]{(KeyboardEvent.Key)Mockito.any(KeyboardEvent.Key.class)});
        this.tested.bind(this.session);
        sessionCallback[0].onKeyShortcut(new KeyboardEvent.Key[]{KeyboardEvent.Key.ESC});
        ((ClientKeyShortcutsHandler.KeyShortcutCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onKeyShortcut(new KeyboardEvent.Key[]{(KeyboardEvent.Key)Mockito.eq((Object)KeyboardEvent.Key.ESC)});
        this.tested.unbind();
        sessionCallback[0].onKeyShortcut(new KeyboardEvent.Key[]{KeyboardEvent.Key.ESC});
        ((ClientKeyShortcutsHandler.KeyShortcutCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onKeyShortcut(new KeyboardEvent.Key[]{(KeyboardEvent.Key)Mockito.any(KeyboardEvent.Key.class)});
    }
}

