/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.service;

import org.jboss.errai.common.client.api.Caller;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.ShapeSet;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.service.ClientDiagramService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.lookup.LookupManager;
import org.kie.workbench.common.stunner.core.lookup.diagram.DiagramLookupRequest;
import org.kie.workbench.common.stunner.core.service.DiagramLookupService;
import org.kie.workbench.common.stunner.core.service.DiagramService;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mocks.CallerMock;

@RunWith(value=MockitoJUnitRunner.class)
public class ClientDiagramServicesTest {
    @Mock
    ShapeManager shapeManager;
    @Mock
    DiagramService diagramService;
    @Mock
    DiagramLookupService diagramLookupService;
    @Mock
    Path path;
    @Mock
    Diagram diagram;
    @Mock
    Metadata metadata;
    private Caller<DiagramService> diagramServiceCaller;
    private Caller<DiagramLookupService> diagramLookupServiceCaller;
    private ClientDiagramService tested;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.diagram.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.metadata.getDefinitionSetId()).thenReturn((Object)"ds1 ");
        Mockito.when((Object)this.metadata.getShapeSetId()).thenReturn((Object)"ss1 ");
        Mockito.when((Object)this.diagramService.saveOrUpdate((Diagram)Matchers.any(Diagram.class))).thenReturn((Object)this.metadata);
        this.diagramServiceCaller = new CallerMock((Object)this.diagramService);
        this.diagramLookupServiceCaller = new CallerMock((Object)this.diagramLookupService);
        this.tested = new ClientDiagramService(this.shapeManager, this.diagramServiceCaller, this.diagramLookupServiceCaller);
    }

    @Test
    public void testCreate() {
        String name = "d1";
        String defSetId = "id1";
        ServiceCallback callback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        this.tested.create(this.path, name, defSetId, callback);
        ((DiagramService)Mockito.verify((Object)this.diagramService, (VerificationMode)Mockito.times((int)1))).create((Path)Matchers.eq((Object)this.path), (String)Matchers.eq((Object)name), (String)Matchers.eq((Object)defSetId));
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSuccess(Matchers.any(Path.class));
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)0))).onError((ClientRuntimeError)Matchers.any(ClientRuntimeError.class));
    }

    @Test
    public void testAdd() {
        ServiceCallback callback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        this.tested.add(this.diagram, callback);
        ((DiagramService)Mockito.verify((Object)this.diagramService, (VerificationMode)Mockito.times((int)1))).saveOrUpdate((Diagram)Matchers.eq((Object)this.diagram));
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSuccess(Matchers.any(Diagram.class));
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)0))).onError((ClientRuntimeError)Matchers.any(ClientRuntimeError.class));
    }

    @Test
    public void testSaveOrUpdate() {
        ServiceCallback callback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        this.tested.saveOrUpdate(this.diagram, callback);
        ((DiagramService)Mockito.verify((Object)this.diagramService, (VerificationMode)Mockito.times((int)1))).saveOrUpdate((Diagram)Matchers.eq((Object)this.diagram));
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSuccess(Matchers.any(Diagram.class));
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)0))).onError((ClientRuntimeError)Matchers.any(ClientRuntimeError.class));
    }

    @Test
    public void testGetByPath() {
        ServiceCallback callback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        this.tested.getByPath(this.path, callback);
        ((DiagramService)Mockito.verify((Object)this.diagramService, (VerificationMode)Mockito.times((int)1))).getDiagramByPath((Path)Matchers.eq((Object)this.path));
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSuccess(Matchers.any(Diagram.class));
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)0))).onError((ClientRuntimeError)Matchers.any(ClientRuntimeError.class));
    }

    @Test
    public void testLookup() {
        DiagramLookupRequest request = (DiagramLookupRequest)Mockito.mock(DiagramLookupRequest.class);
        ServiceCallback callback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        this.tested.lookup(request, callback);
        ((DiagramLookupService)Mockito.verify((Object)this.diagramLookupService, (VerificationMode)Mockito.times((int)1))).lookup((LookupManager.LookupRequest)Matchers.eq((Object)request));
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSuccess(Matchers.any(LookupManager.LookupResponse.class));
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)0))).onError((ClientRuntimeError)Matchers.any(ClientRuntimeError.class));
    }

    @Test
    public void testUpdateClientMetadata() {
        String ssid = "shapeSet1";
        ShapeSet shapeSet = (ShapeSet)Mockito.mock(ShapeSet.class);
        Mockito.when((Object)shapeSet.getId()).thenReturn((Object)ssid);
        Mockito.when((Object)this.shapeManager.getDefaultShapeSet(Matchers.anyString())).thenReturn((Object)shapeSet);
        Mockito.when((Object)this.metadata.getShapeSetId()).thenReturn(null);
        ServiceCallback callback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        Mockito.when((Object)this.diagramService.getDiagramByPath((Path)Matchers.eq((Object)this.path))).thenReturn((Object)this.diagram);
        this.tested.add(this.diagram, callback);
        this.tested.saveOrUpdate(this.diagram, callback);
        this.tested.getByPath(this.path, callback);
        ((Metadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.times((int)3))).setShapeSetId((String)Matchers.eq((Object)ssid));
    }
}

