/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasFileExport;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ExportToJpgSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class ExportToJpgSessionCommandTest {
    private static final String FILE_NAME = "file-name1";
    @Mock
    private CanvasFileExport canvasFileExport;
    @Mock
    private AbstractClientSession session;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Diagram diagram;
    @Mock
    private Metadata metadata;
    @Mock
    private Path path;
    @Mock
    private ClientSessionCommand.Callback callback;
    private ExportToJpgSessionCommand tested;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.diagram.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.metadata.getPath()).thenReturn((Object)this.path);
        Mockito.when((Object)this.path.getFileName()).thenReturn((Object)FILE_NAME);
        this.tested = new ExportToJpgSessionCommand(this.canvasFileExport);
        this.tested.bind((ClientSession)this.session);
    }

    @Test
    public void testExport() {
        this.tested.execute(this.callback);
        ((CanvasFileExport)Mockito.verify((Object)this.canvasFileExport, (VerificationMode)Mockito.times((int)1))).exportToJpg((AbstractCanvasHandler)Matchers.eq((Object)this.canvasHandler), (String)Matchers.eq((Object)FILE_NAME));
        ((CanvasFileExport)Mockito.verify((Object)this.canvasFileExport, (VerificationMode)Mockito.never())).exportToPng((AbstractCanvasHandler)Matchers.any(AbstractCanvasHandler.class), Matchers.anyString());
        ((CanvasFileExport)Mockito.verify((Object)this.canvasFileExport, (VerificationMode)Mockito.never())).exportToPdf((AbstractCanvasHandler)Matchers.any(AbstractCanvasHandler.class), Matchers.anyString());
    }
}

