/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.impl;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSession;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class AbstractClientSessionTest {
    @Mock
    AbstractCanvas canvas;
    @Mock
    AbstractCanvasHandler canvasHandler;
    private AbstractClientSession tested;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.canvasHandler.getCanvas()).thenReturn((Object)this.canvas);
        this.tested = (AbstractClientSession)Mockito.spy((Object)((Object)new AbstractClientSessionStub(this.canvas, this.canvasHandler)));
    }

    @Test
    public void testOpen() {
        this.tested.open();
        Assert.assertTrue((boolean)this.tested.isOpened());
        ((AbstractClientSession)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)1))).doOpen();
        ((AbstractClientSession)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).doPause();
        ((AbstractClientSession)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).doResume();
        ((AbstractClientSession)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).doDestroy();
    }

    @Test
    public void testPause() {
        this.tested.isOpened = true;
        this.tested.pause();
        Assert.assertTrue((boolean)this.tested.isOpened());
        ((AbstractClientSession)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).doOpen();
        ((AbstractClientSession)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)1))).doPause();
        ((AbstractClientSession)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).doResume();
        ((AbstractClientSession)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).doDestroy();
    }

    @Test(expected=IllegalStateException.class)
    public void testCannotPause() {
        this.tested.isOpened = false;
        this.tested.pause();
    }

    @Test
    public void testResume() {
        this.tested.isOpened = true;
        this.tested.resume();
        Assert.assertTrue((boolean)this.tested.isOpened());
        ((AbstractClientSession)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).doOpen();
        ((AbstractClientSession)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).doPause();
        ((AbstractClientSession)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)1))).doResume();
        ((AbstractClientSession)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).doDestroy();
    }

    @Test
    public void testCannotResume() {
        this.tested.isOpened = false;
        this.tested.resume();
        ((AbstractClientSession)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).doOpen();
        ((AbstractClientSession)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).doPause();
        ((AbstractClientSession)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).doResume();
        ((AbstractClientSession)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).doDestroy();
    }

    @Test
    public void testDestroy() {
        this.tested.isOpened = true;
        this.tested.destroy();
        Assert.assertFalse((boolean)this.tested.isOpened());
        ((AbstractClientSession)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).doOpen();
        ((AbstractClientSession)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).doPause();
        ((AbstractClientSession)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).doResume();
        ((AbstractClientSession)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)1))).doDestroy();
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).destroy();
    }

    @Test(expected=IllegalStateException.class)
    public void testCannotDestroy() {
        this.tested.isOpened = false;
        this.tested.destroy();
    }

    private class AbstractClientSessionStub
    extends AbstractClientSession {
        AbstractClientSessionStub(AbstractCanvas canvas, AbstractCanvasHandler canvasHandler) {
            super(canvas, canvasHandler);
        }

        protected void doOpen() {
        }

        protected void doPause() {
        }

        protected void doResume() {
        }

        protected void doDestroy() {
        }
    }
}

