/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.impl;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasFactory;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.CanvasInPlaceTextEditorControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.ElementBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.connection.ConnectionAcceptorControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.containment.ContainmentAcceptorControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.docking.DockingAcceptorControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.drag.DragControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.pan.PanControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.resize.ResizeControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.ToolboxControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.zoom.ZoomControl;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasElementListener;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasShapeListener;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.impl.ClientFullSessionImpl;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.registry.RegistryFactory;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ClientFullSessionTest {
    @Mock
    CanvasFactory<AbstractCanvas, AbstractCanvasHandler> factory;
    @Mock
    AbstractCanvas canvas;
    @Mock
    AbstractCanvasHandler canvasHandler;
    @Mock
    SelectionControl<AbstractCanvasHandler, Element> selectionControl;
    @Mock
    ZoomControl<AbstractCanvas> zoomControl;
    @Mock
    PanControl<AbstractCanvas> panControl;
    @Mock
    ResizeControl<AbstractCanvasHandler, Element> resizeControl;
    @Mock
    CanvasCommandManager<AbstractCanvasHandler> canvasCommandManager;
    @Mock
    SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    SessionCommandManager<AbstractCanvasHandler> requestCommandManager;
    @Mock
    RegistryFactory registryFactory;
    @Mock
    ConnectionAcceptorControl<AbstractCanvasHandler> connectionAcceptorControl;
    @Mock
    ContainmentAcceptorControl<AbstractCanvasHandler> containmentAcceptorControl;
    @Mock
    DockingAcceptorControl<AbstractCanvasHandler> dockingAcceptorControl;
    @Mock
    CanvasInPlaceTextEditorControl<AbstractCanvasHandler, Element> canvasInPlaceTextEditorControl;
    @Mock
    DragControl<AbstractCanvasHandler, Element> dragControl;
    @Mock
    ToolboxControl<AbstractCanvasHandler, Element> toolboxControl;
    @Mock
    ElementBuilderControl<AbstractCanvasHandler> builderControl;
    private ClientFullSessionImpl tested;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.factory.newCanvas()).thenReturn((Object)this.canvas);
        Mockito.when((Object)this.factory.newCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(ZoomControl.class))).thenReturn(this.zoomControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(PanControl.class))).thenReturn(this.panControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(SelectionControl.class))).thenReturn(this.selectionControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(ResizeControl.class))).thenReturn(this.resizeControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(ConnectionAcceptorControl.class))).thenReturn(this.connectionAcceptorControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(ContainmentAcceptorControl.class))).thenReturn(this.containmentAcceptorControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(DockingAcceptorControl.class))).thenReturn(this.dockingAcceptorControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(DragControl.class))).thenReturn(this.dragControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(CanvasInPlaceTextEditorControl.class))).thenReturn(this.canvasInPlaceTextEditorControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(ToolboxControl.class))).thenReturn(this.toolboxControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(ElementBuilderControl.class))).thenReturn(this.builderControl);
        Mockito.when((Object)this.canvasHandler.getCanvas()).thenReturn((Object)this.canvas);
    }

    @Test
    public void testInit() {
        this.buildTestedInstance();
        Assert.assertEquals((Object)this.canvas, (Object)this.tested.getCanvas());
        Assert.assertEquals((Object)this.canvasHandler, (Object)this.tested.getCanvasHandler());
        Assert.assertEquals(this.selectionControl, (Object)this.tested.getSelectionControl());
        Assert.assertEquals(this.zoomControl, (Object)this.tested.getZoomControl());
        Assert.assertEquals(this.panControl, (Object)this.tested.getPanControl());
        Assert.assertEquals(this.resizeControl, (Object)this.tested.getResizeControl());
        Assert.assertEquals(this.canvasCommandManager, (Object)this.tested.getCommandManager());
        Assert.assertEquals(this.connectionAcceptorControl, (Object)this.tested.getConnectionAcceptorControl());
        Assert.assertEquals(this.containmentAcceptorControl, (Object)this.tested.getContainmentAcceptorControl());
        Assert.assertEquals(this.dockingAcceptorControl, (Object)this.tested.getDockingAcceptorControl());
        Assert.assertEquals(this.canvasInPlaceTextEditorControl, (Object)this.tested.getCanvasInPlaceTextEditorControl());
        Assert.assertEquals(this.dragControl, (Object)this.tested.getDragControl());
        Assert.assertEquals(this.toolboxControl, (Object)this.tested.getToolboxControl());
        Assert.assertEquals(this.builderControl, (Object)this.tested.getBuilderControl());
        ArgumentCaptor conn = ArgumentCaptor.forClass(RequiresCommandManager.CommandManagerProvider.class);
        ((ConnectionAcceptorControl)Mockito.verify(this.connectionAcceptorControl, (VerificationMode)Mockito.times((int)1))).setCommandManagerProvider((RequiresCommandManager.CommandManagerProvider)conn.capture());
        Assert.assertEquals(this.requestCommandManager, (Object)((RequiresCommandManager.CommandManagerProvider)conn.getValue()).getCommandManager());
        ArgumentCaptor cont = ArgumentCaptor.forClass(RequiresCommandManager.CommandManagerProvider.class);
        ((ContainmentAcceptorControl)Mockito.verify(this.containmentAcceptorControl, (VerificationMode)Mockito.times((int)1))).setCommandManagerProvider((RequiresCommandManager.CommandManagerProvider)cont.capture());
        Assert.assertEquals(this.requestCommandManager, (Object)((RequiresCommandManager.CommandManagerProvider)cont.getValue()).getCommandManager());
        ArgumentCaptor docking = ArgumentCaptor.forClass(RequiresCommandManager.CommandManagerProvider.class);
        ((DockingAcceptorControl)Mockito.verify(this.dockingAcceptorControl, (VerificationMode)Mockito.times((int)1))).setCommandManagerProvider((RequiresCommandManager.CommandManagerProvider)docking.capture());
        Assert.assertEquals(this.requestCommandManager, (Object)((RequiresCommandManager.CommandManagerProvider)docking.getValue()).getCommandManager());
        ArgumentCaptor builder = ArgumentCaptor.forClass(RequiresCommandManager.CommandManagerProvider.class);
        ((ElementBuilderControl)Mockito.verify(this.builderControl, (VerificationMode)Mockito.times((int)1))).setCommandManagerProvider((RequiresCommandManager.CommandManagerProvider)builder.capture());
        Assert.assertEquals(this.sessionCommandManager, (Object)((RequiresCommandManager.CommandManagerProvider)builder.getValue()).getCommandManager());
        ArgumentCaptor drag = ArgumentCaptor.forClass(RequiresCommandManager.CommandManagerProvider.class);
        ((DragControl)Mockito.verify(this.dragControl, (VerificationMode)Mockito.times((int)1))).setCommandManagerProvider((RequiresCommandManager.CommandManagerProvider)drag.capture());
        Assert.assertEquals(this.requestCommandManager, (Object)((RequiresCommandManager.CommandManagerProvider)drag.getValue()).getCommandManager());
        ArgumentCaptor resize = ArgumentCaptor.forClass(RequiresCommandManager.CommandManagerProvider.class);
        ((ResizeControl)Mockito.verify(this.resizeControl, (VerificationMode)Mockito.times((int)1))).setCommandManagerProvider((RequiresCommandManager.CommandManagerProvider)resize.capture());
        Assert.assertEquals(this.sessionCommandManager, (Object)((RequiresCommandManager.CommandManagerProvider)resize.getValue()).getCommandManager());
        ArgumentCaptor toolbox = ArgumentCaptor.forClass(RequiresCommandManager.CommandManagerProvider.class);
        ((ToolboxControl)Mockito.verify(this.toolboxControl, (VerificationMode)Mockito.times((int)1))).setCommandManagerProvider((RequiresCommandManager.CommandManagerProvider)toolbox.capture());
        Assert.assertEquals(this.sessionCommandManager, (Object)((RequiresCommandManager.CommandManagerProvider)toolbox.getValue()).getCommandManager());
        ArgumentCaptor name = ArgumentCaptor.forClass(RequiresCommandManager.CommandManagerProvider.class);
        ((CanvasInPlaceTextEditorControl)Mockito.verify(this.canvasInPlaceTextEditorControl, (VerificationMode)Mockito.times((int)1))).setCommandManagerProvider((RequiresCommandManager.CommandManagerProvider)name.capture());
        Assert.assertEquals(this.sessionCommandManager, (Object)((RequiresCommandManager.CommandManagerProvider)name.getValue()).getCommandManager());
    }

    @Test
    public void testOpenSession() {
        this.buildTestedInstance();
        this.tested.open();
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).addRegistrationListener((CanvasShapeListener)Matchers.any(CanvasShapeListener.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).addRegistrationListener((CanvasElementListener)Matchers.any(CanvasElementListener.class));
        ((SelectionControl)Mockito.verify(this.selectionControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvasHandler));
        ((ZoomControl)Mockito.verify(this.zoomControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvas));
        ((PanControl)Mockito.verify(this.panControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvas));
        ((ResizeControl)Mockito.verify(this.resizeControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvasHandler));
        ((ConnectionAcceptorControl)Mockito.verify(this.connectionAcceptorControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvasHandler));
        ((ContainmentAcceptorControl)Mockito.verify(this.containmentAcceptorControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvasHandler));
        ((DockingAcceptorControl)Mockito.verify(this.dockingAcceptorControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvasHandler));
        ((CanvasInPlaceTextEditorControl)Mockito.verify(this.canvasInPlaceTextEditorControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvasHandler));
        ((DragControl)Mockito.verify(this.dragControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvasHandler));
        ((ToolboxControl)Mockito.verify(this.toolboxControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvasHandler));
        ((ElementBuilderControl)Mockito.verify(this.builderControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvasHandler));
    }

    @Test
    public void testDestroySession() {
        this.buildTestedInstance();
        this.tested.isOpened = true;
        this.tested.doOpen();
        this.tested.destroy();
        Assert.assertFalse((boolean)this.tested.isOpened());
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).removeRegistrationListener((CanvasShapeListener)Matchers.any(CanvasShapeListener.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).removeRegistrationListener((CanvasElementListener)Matchers.any(CanvasElementListener.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).destroy();
        ((SelectionControl)Mockito.verify(this.selectionControl, (VerificationMode)Mockito.times((int)1))).disable();
        ((ZoomControl)Mockito.verify(this.zoomControl, (VerificationMode)Mockito.times((int)1))).disable();
        ((PanControl)Mockito.verify(this.panControl, (VerificationMode)Mockito.times((int)1))).disable();
        ((ResizeControl)Mockito.verify(this.resizeControl, (VerificationMode)Mockito.times((int)1))).disable();
        ((ConnectionAcceptorControl)Mockito.verify(this.connectionAcceptorControl, (VerificationMode)Mockito.times((int)1))).disable();
        ((ContainmentAcceptorControl)Mockito.verify(this.containmentAcceptorControl, (VerificationMode)Mockito.times((int)1))).disable();
        ((DockingAcceptorControl)Mockito.verify(this.dockingAcceptorControl, (VerificationMode)Mockito.times((int)1))).disable();
        ((CanvasInPlaceTextEditorControl)Mockito.verify(this.canvasInPlaceTextEditorControl, (VerificationMode)Mockito.times((int)1))).disable();
        ((DragControl)Mockito.verify(this.dragControl, (VerificationMode)Mockito.times((int)1))).disable();
        ((ToolboxControl)Mockito.verify(this.toolboxControl, (VerificationMode)Mockito.times((int)1))).disable();
        ((ElementBuilderControl)Mockito.verify(this.builderControl, (VerificationMode)Mockito.times((int)1))).disable();
    }

    private void buildTestedInstance() {
        this.tested = new ClientFullSessionImpl(this.factory, this.canvasCommandManager, this.sessionCommandManager, this.requestCommandManager, this.registryFactory);
    }
}

