/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.impl;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasFactory;
import org.kie.workbench.common.stunner.core.client.canvas.controls.pan.PanControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.zoom.ZoomControl;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasElementListener;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasShapeListener;
import org.kie.workbench.common.stunner.core.client.session.impl.ClientReadOnlySessionImpl;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ClientReadOnlySessionTest {
    @Mock
    CanvasFactory<AbstractCanvas, AbstractCanvasHandler> factory;
    @Mock
    AbstractCanvas canvas;
    @Mock
    AbstractCanvasHandler canvasHandler;
    @Mock
    SelectionControl<AbstractCanvasHandler, Element> selectionControl;
    @Mock
    ZoomControl<AbstractCanvas> zoomControl;
    @Mock
    PanControl<AbstractCanvas> panControl;
    private ClientReadOnlySessionImpl tested;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.factory.newCanvas()).thenReturn((Object)this.canvas);
        Mockito.when((Object)this.factory.newCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(ZoomControl.class))).thenReturn(this.zoomControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(PanControl.class))).thenReturn(this.panControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(SelectionControl.class))).thenReturn(this.selectionControl);
        Mockito.when((Object)this.canvasHandler.getCanvas()).thenReturn((Object)this.canvas);
        this.tested = new ClientReadOnlySessionImpl(this.factory);
    }

    @Test
    public void testInit() {
        Assert.assertEquals((Object)this.canvas, (Object)this.tested.getCanvas());
        Assert.assertEquals((Object)this.canvasHandler, (Object)this.tested.getCanvasHandler());
        Assert.assertEquals(this.selectionControl, (Object)this.tested.getSelectionControl());
        Assert.assertEquals(this.zoomControl, (Object)this.tested.getZoomControl());
        Assert.assertEquals(this.panControl, (Object)this.tested.getPanControl());
    }

    @Test
    public void testOpenSession() {
        this.tested.open();
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).addRegistrationListener((CanvasShapeListener)Matchers.any(CanvasShapeListener.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).addRegistrationListener((CanvasElementListener)Matchers.any(CanvasElementListener.class));
        ((SelectionControl)Mockito.verify(this.selectionControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvasHandler));
        ((ZoomControl)Mockito.verify(this.zoomControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvas));
        ((PanControl)Mockito.verify(this.panControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvas));
    }

    @Test
    public void testDestroySession() {
        this.tested.isOpened = true;
        this.tested.doOpen();
        this.tested.destroy();
        Assert.assertFalse((boolean)this.tested.isOpened());
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).removeRegistrationListener((CanvasShapeListener)Matchers.any(CanvasShapeListener.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).removeRegistrationListener((CanvasElementListener)Matchers.any(CanvasElementListener.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).destroy();
        ((SelectionControl)Mockito.verify(this.selectionControl, (VerificationMode)Mockito.times((int)1))).disable();
        ((ZoomControl)Mockito.verify(this.zoomControl, (VerificationMode)Mockito.times((int)1))).disable();
        ((PanControl)Mockito.verify(this.panControl, (VerificationMode)Mockito.times((int)1))).disable();
    }
}

