/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape;

import com.google.gwt.safehtml.shared.SafeUri;
import java.util.Collection;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.shape.ImageDataUriGlyph;
import org.kie.workbench.common.stunner.core.client.shape.SvgDataUriGlyph;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.definition.shape.ShapeGlyph;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class GlyphTests {
    private static final String IMAGE_JPG_URI = "data:image/jpeg;base64,9j/4AAQSkZJRgABAQEASABIAAD";
    private static final String IMAGE_SVG_URI = "data:image/svg+xml;base64,c3ZnLWNvbnRlbnQ=";
    @Mock
    private SafeUri jpgUri;
    @Mock
    private SafeUri svgUri;
    @Mock
    private SafeUri svgUri2;
    @Mock
    private SafeUri svgUri3;
    @Mock
    private Supplier<ShapeFactory> factorySupplier;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.jpgUri.asString()).thenReturn((Object)IMAGE_JPG_URI);
        Mockito.when((Object)this.svgUri.asString()).thenReturn((Object)IMAGE_SVG_URI);
    }

    @Test
    public void testShapeGlyph() {
        ShapeGlyph glyph = ShapeGlyph.create();
        glyph.setDefinitionId("def1");
        glyph.setFactorySupplier(this.factorySupplier);
        Assert.assertEquals((Object)"def1", (Object)glyph.getDefinitionId());
        Assert.assertEquals(this.factorySupplier, (Object)glyph.getFactorySupplier());
    }

    @Test
    public void testImageDataUriGlyph() {
        ImageDataUriGlyph imageDataUriGlyph = ImageDataUriGlyph.create((SafeUri)this.jpgUri);
        Assert.assertEquals((Object)this.jpgUri, (Object)imageDataUriGlyph.getUri());
    }

    @Test
    public void testSvgDataUriGlyph() {
        SvgDataUriGlyph svgDataUriGlyph = SvgDataUriGlyph.Builder.build((SafeUri)this.svgUri);
        Assert.assertEquals((Object)this.svgUri, (Object)svgDataUriGlyph.getSvg());
        Assert.assertTrue((boolean)svgDataUriGlyph.getDefs().isEmpty());
        Assert.assertTrue((boolean)svgDataUriGlyph.getValidUseRefIds().isEmpty());
    }

    @Test
    public void testSvgDataUriGlyphComposite() {
        SvgDataUriGlyph.Builder builder = SvgDataUriGlyph.Builder.create().setUri(this.svgUri).addUri("uri2", this.svgUri2).addUri("uri3", this.svgUri3);
        SvgDataUriGlyph svgDataUriGlyph = builder.build();
        Collection defs = svgDataUriGlyph.getDefs();
        Collection ids = svgDataUriGlyph.getValidUseRefIds();
        Assert.assertEquals((Object)this.svgUri, (Object)svgDataUriGlyph.getSvg());
        Assert.assertEquals((long)2L, (long)defs.size());
        Assert.assertEquals((long)2L, (long)ids.size());
        Assert.assertTrue((boolean)defs.contains(this.svgUri2));
        Assert.assertTrue((boolean)defs.contains(this.svgUri3));
        Assert.assertTrue((boolean)ids.contains("uri2"));
        Assert.assertTrue((boolean)ids.contains("uri3"));
    }

    @Test
    public void testSvgDataUriGlyphFilterComposite() {
        SvgDataUriGlyph.Builder builder = SvgDataUriGlyph.Builder.create().setUri(this.svgUri).addUri("uri2", this.svgUri2).addUri("uri3", this.svgUri3);
        SvgDataUriGlyph svgDataUriGlyph1 = builder.build("uri3");
        Collection defs1 = svgDataUriGlyph1.getDefs();
        Collection ids1 = svgDataUriGlyph1.getValidUseRefIds();
        Assert.assertEquals((Object)this.svgUri, (Object)svgDataUriGlyph1.getSvg());
        Assert.assertEquals((long)1L, (long)defs1.size());
        Assert.assertEquals((long)1L, (long)defs1.size());
        Assert.assertTrue((boolean)defs1.contains(this.svgUri3));
        Assert.assertTrue((boolean)ids1.contains("uri3"));
        SvgDataUriGlyph svgDataUriGlyph2 = builder.build("uri2");
        Collection defs2 = svgDataUriGlyph2.getDefs();
        Collection ids2 = svgDataUriGlyph2.getValidUseRefIds();
        Assert.assertEquals((Object)this.svgUri, (Object)svgDataUriGlyph2.getSvg());
        Assert.assertEquals((long)1L, (long)defs2.size());
        Assert.assertEquals((long)1L, (long)defs2.size());
        Assert.assertTrue((boolean)defs2.contains(this.svgUri2));
        Assert.assertTrue((boolean)ids2.contains("uri2"));
    }
}

