/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.kie.workbench.common.stunner.core.client.shape.ShapeViewStub;
import org.kie.workbench.common.stunner.core.client.shape.view.HasControlPoints;
import org.kie.workbench.common.stunner.core.client.shape.view.HasDecorators;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.HasFillGradient;
import org.kie.workbench.common.stunner.core.client.shape.view.HasRadius;
import org.kie.workbench.common.stunner.core.client.shape.view.HasSize;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;

public class ShapeViewExtStub
extends ShapeViewStub
implements ShapeView<Object>,
HasEventHandlers<ShapeViewExtStub, Object>,
HasControlPoints<ShapeViewExtStub>,
HasDecorators<Object>,
HasFillGradient<Object>,
HasTitle<Object>,
HasSize<Object>,
HasRadius<Object> {
    private final List<Object> decorators = new ArrayList<Object>();
    private final Optional<HasEventHandlers<ShapeViewExtStub, Object>> hasEventHandlers;
    private final Optional<HasControlPoints<ShapeViewExtStub>> hasControlPoints;

    public ShapeViewExtStub() {
        this.hasEventHandlers = Optional.empty();
        this.hasControlPoints = Optional.empty();
    }

    public ShapeViewExtStub(HasEventHandlers<ShapeViewExtStub, Object> hasEventHandlers, HasControlPoints<ShapeViewExtStub> hasControlPoints) {
        this.hasEventHandlers = Optional.of(hasEventHandlers);
        this.hasControlPoints = Optional.of(hasControlPoints);
    }

    public Object setFillGradient(HasFillGradient.Type type, String startColor, String endColor) {
        return this;
    }

    public Object setTitle(String title) {
        return this;
    }

    public Object setTitlePosition(HasTitle.Position position) {
        return this;
    }

    public Object setTitleRotation(double degrees) {
        return this;
    }

    public Object setTitleStrokeColor(String color) {
        return this;
    }

    public Object setTitleFontFamily(String fontFamily) {
        return this;
    }

    public Object setTitleFontSize(double fontSize) {
        return this;
    }

    public Object setTitleFontColor(String fillColor) {
        return this;
    }

    public Object setTitleStrokeWidth(double strokeWidth) {
        return this;
    }

    public Object setTitleAlpha(double alpha) {
        return this;
    }

    public Object moveTitleToTop() {
        return this;
    }

    public Object setRadius(double radius) {
        return this;
    }

    public Object setSize(double width, double height) {
        return this;
    }

    public List<Object> getDecorators() {
        return this.decorators;
    }

    public boolean supports(ViewEventType type) {
        return this.hasEventHandlers.isPresent() && this.hasEventHandlers.get().supports(type);
    }

    public ShapeViewExtStub addHandler(ViewEventType type, ViewHandler<? extends ViewEvent> eventHandler) {
        this.hasEventHandlers.ifPresent(h -> {
            ShapeViewExtStub cfr_ignored_0 = (ShapeViewExtStub)h.addHandler(type, eventHandler);
        });
        return this;
    }

    public ShapeViewExtStub removeHandler(ViewHandler<? extends ViewEvent> eventHandler) {
        this.hasEventHandlers.ifPresent(h -> {
            ShapeViewExtStub cfr_ignored_0 = (ShapeViewExtStub)h.removeHandler(eventHandler);
        });
        return this;
    }

    public ShapeViewExtStub enableHandlers() {
        this.hasEventHandlers.ifPresent(HasEventHandlers::enableHandlers);
        return this;
    }

    public ShapeViewExtStub disableHandlers() {
        this.hasEventHandlers.ifPresent(HasEventHandlers::disableHandlers);
        return this;
    }

    public Object getAttachableShape() {
        return this.hasEventHandlers.map(HasEventHandlers::getAttachableShape).orElse(null);
    }

    public ShapeViewExtStub showControlPoints(HasControlPoints.ControlPointType type) {
        this.hasControlPoints.ifPresent(h -> {
            ShapeViewExtStub cfr_ignored_0 = (ShapeViewExtStub)h.showControlPoints(type);
        });
        return this;
    }

    public ShapeViewExtStub hideControlPoints() {
        this.hasControlPoints.ifPresent(HasControlPoints::hideControlPoints);
        return this;
    }

    public boolean areControlsVisible() {
        return this.hasControlPoints.isPresent() && this.hasControlPoints.get().areControlsVisible();
    }
}

