/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.factory;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.DelegateShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeDefTestStubs;
import org.kie.workbench.common.stunner.core.definition.shape.ShapeDef;
import org.kie.workbench.common.stunner.core.definition.shape.ShapeGlyph;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DelegateShapeFactoryTest {
    @Mock
    ShapeDefTestStubs.TestShapeDefFactoryStub shapeDefFactoryStub;
    @Mock
    Shape shape1;
    @Mock
    Shape shape2;
    private DelegateShapeFactory tested;
    private static Definition1 definition1 = new Definition1();
    private static ShapeDefTestStubs.TestShapeDefType1 shapeDef1 = new ShapeDefTestStubs.TestShapeDefType1();
    private static Definition2 definition2 = new Definition2();
    private static ShapeDefTestStubs.TestShapeDefType2 shapeDef2 = new ShapeDefTestStubs.TestShapeDefType2();

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.shapeDefFactoryStub.newShape(Matchers.eq((Object)definition1), (ShapeDef)Matchers.eq((Object)shapeDef1))).thenReturn((Object)this.shape1);
        Mockito.when((Object)this.shapeDefFactoryStub.newShape(Matchers.eq((Object)definition2), (ShapeDef)Matchers.eq((Object)shapeDef2))).thenReturn((Object)this.shape2);
        this.tested = new DelegateShapeFactory();
    }

    @Test
    public void testDelegate1() {
        String definition1Id = DelegateShapeFactory.getDefinitionId(Definition1.class);
        this.tested.delegate(Definition1.class, (ShapeDef)shapeDef1, () -> this.shapeDefFactoryStub);
        Shape shape = this.tested.newShape((Object)definition1);
        Assert.assertNotNull((Object)shape);
        Assert.assertEquals((Object)this.shape1, (Object)shape);
        ShapeGlyph glyph = (ShapeGlyph)this.tested.getGlyph(definition1Id);
        Assert.assertNotNull((Object)glyph);
        Assert.assertEquals((Object)definition1Id, (Object)glyph.getDefinitionId());
        Assert.assertEquals((Object)this.tested, glyph.getFactorySupplier().get());
    }

    @Test
    public void testDelegate2() {
        String definition2Id = DelegateShapeFactory.getDefinitionId(Definition2.class);
        this.tested.delegate(Definition2.class, (ShapeDef)shapeDef2, () -> this.shapeDefFactoryStub);
        Shape shape = this.tested.newShape((Object)definition2);
        Assert.assertNotNull((Object)shape);
        Assert.assertEquals((Object)this.shape2, (Object)shape);
        ShapeGlyph glyph = (ShapeGlyph)this.tested.getGlyph(definition2Id);
        Assert.assertNotNull((Object)glyph);
        Assert.assertEquals((Object)definition2Id, (Object)glyph.getDefinitionId());
        Assert.assertEquals((Object)this.tested, glyph.getFactorySupplier().get());
    }

    @Test(expected=RuntimeException.class)
    public void testNoBindingFound() {
        this.tested.newShape((Object)definition1);
    }

    private static class Definition2 {
        private Definition2() {
        }
    }

    private static class Definition1 {
        private Definition1() {
        }
    }
}

