/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.factory;

import java.util.function.BiFunction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeDefFunctionalFactory;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeDefTestStubs;
import org.kie.workbench.common.stunner.core.definition.shape.ShapeDef;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ShapeDefFunctionalFactoryTest {
    @Mock
    private BiFunction<Object, ShapeDef<Object>, Shape> shapeDef1FactoryFunction;
    @Mock
    private BiFunction<Object, ShapeDef<Object>, Shape> shapeDef2FactoryFunction;
    @Mock
    private Shape shape1;
    @Mock
    private Shape shape2;
    @Mock
    private Object definitionBean;
    private ShapeDefFunctionalFactory<Object, ShapeDef<Object>, Shape> tested;
    private static final ShapeDefTestStubs.TestShapeDefType1 shapeDef1 = new ShapeDefTestStubs.TestShapeDefType1();
    private static final ShapeDefTestStubs.TestShapeDefType2 shapeDef2 = new ShapeDefTestStubs.TestShapeDefType2();

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.shapeDef1FactoryFunction.apply(Matchers.eq((Object)this.definitionBean), (ShapeDef<Object>)Matchers.eq((Object)shapeDef1))).thenReturn((Object)this.shape1);
        Mockito.when((Object)this.shapeDef2FactoryFunction.apply(Matchers.eq((Object)this.definitionBean), (ShapeDef<Object>)Matchers.eq((Object)shapeDef2))).thenReturn((Object)this.shape2);
        this.tested = new ShapeDefFunctionalFactory();
    }

    @Test
    public void testCreateShapeForDef1() {
        this.tested.set(ShapeDefTestStubs.TestShapeDefType1.class, this.shapeDef1FactoryFunction);
        Shape shape = this.tested.newShape(this.definitionBean, (ShapeDef)shapeDef1);
        Assert.assertNotNull((Object)shape);
        Assert.assertEquals((Object)this.shape1, (Object)shape);
    }

    @Test
    public void testCreateShapeForDef2() {
        this.tested.set(ShapeDefTestStubs.TestShapeDefType2.class, this.shapeDef2FactoryFunction);
        Shape shape = this.tested.newShape(this.definitionBean, (ShapeDef)shapeDef2);
        Assert.assertNotNull((Object)shape);
        Assert.assertEquals((Object)this.shape2, (Object)shape);
    }

    @Test
    public void testCreateAll() {
        this.tested.set(ShapeDefTestStubs.TestShapeDefType1.class, this.shapeDef1FactoryFunction);
        this.tested.set(ShapeDefTestStubs.TestShapeDefType2.class, this.shapeDef2FactoryFunction);
        Shape s1 = this.tested.newShape(this.definitionBean, (ShapeDef)shapeDef1);
        Shape s2 = this.tested.newShape(this.definitionBean, (ShapeDef)shapeDef2);
        Assert.assertNotNull((Object)s1);
        Assert.assertEquals((Object)this.shape1, (Object)s1);
        Assert.assertNotNull((Object)s2);
        Assert.assertEquals((Object)this.shape2, (Object)s2);
    }

    @Test(expected=RuntimeException.class)
    public void testNoDefinitionRegistered() {
        this.tested.newShape(this.definitionBean, (ShapeDef)shapeDef1);
    }
}

