/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.impl;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.ShapeViewExtStub;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeDefViewHandler;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeViewHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.definition.shape.MutableShapeDef;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ShapeDefViewHandlerTest {
    private static final String COLOR = "#AABBCC";
    private static final String COLOR2 = "#AABBCD";
    private static final Double DOUBLE_VALUE = 0.2;
    @Mock
    MutableShapeDef<Object> def;
    @Mock
    ShapeViewHandler<ShapeViewExtStub> viewHandler;
    private ShapeDefViewHandler<Object, ShapeViewExtStub, MutableShapeDef<Object>> tested;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.def.getBackgroundColor(Matchers.any(Object.class))).thenReturn((Object)COLOR);
        Mockito.when((Object)this.def.getBackgroundAlpha(Matchers.any(Object.class))).thenReturn((Object)DOUBLE_VALUE);
        Mockito.when((Object)this.def.getBorderColor(Matchers.any(Object.class))).thenReturn((Object)COLOR);
        Mockito.when((Object)this.def.getBorderSize(Matchers.any(Object.class))).thenReturn((Object)DOUBLE_VALUE);
        Mockito.when((Object)this.def.getBorderAlpha(Matchers.any(Object.class))).thenReturn((Object)DOUBLE_VALUE);
        Mockito.when((Object)this.def.getFontFamily(Matchers.any(Object.class))).thenReturn((Object)COLOR);
        Mockito.when((Object)this.def.getFontColor(Matchers.any(Object.class))).thenReturn((Object)COLOR);
        Mockito.when((Object)this.def.getFontSize(Matchers.any(Object.class))).thenReturn((Object)DOUBLE_VALUE);
        Mockito.when((Object)this.def.getFontBorderSize(Matchers.any(Object.class))).thenReturn((Object)DOUBLE_VALUE);
        Mockito.when((Object)this.def.getFontBorderColor(Matchers.any(Object.class))).thenReturn((Object)COLOR2);
        Mockito.when((Object)this.def.getFontPosition(Matchers.any(Object.class))).thenReturn((Object)HasTitle.Position.BOTTOM);
        Mockito.when((Object)this.def.getFontRotation(Matchers.any(Object.class))).thenReturn((Object)DOUBLE_VALUE);
        this.tested = new ShapeDefViewHandler(this.def, this.viewHandler);
    }

    @Test
    public void testApplyProperties() {
        this.tested.applyProperties(Mockito.mock(Object.class), MutationContext.STATIC);
        this.tested.applyTitle("newTitle", Mockito.mock(Object.class), MutationContext.STATIC);
        ((ShapeViewHandler)Mockito.verify(this.viewHandler, (VerificationMode)Mockito.times((int)1))).applyFillColor((String)Matchers.eq((Object)COLOR), (MutationContext)Matchers.eq((Object)MutationContext.STATIC));
        ((ShapeViewHandler)Mockito.verify(this.viewHandler, (VerificationMode)Mockito.times((int)1))).applyFillAlpha((Double)Matchers.eq((Object)DOUBLE_VALUE), (MutationContext)Matchers.eq((Object)MutationContext.STATIC));
        ((ShapeViewHandler)Mockito.verify(this.viewHandler, (VerificationMode)Mockito.times((int)1))).applyBorders((String)Matchers.eq((Object)COLOR), (Double)Matchers.eq((Object)DOUBLE_VALUE), (MutationContext)Matchers.eq((Object)MutationContext.STATIC));
        ((ShapeViewHandler)Mockito.verify(this.viewHandler, (VerificationMode)Mockito.times((int)1))).applyBorderAlpha((Double)Matchers.eq((Object)DOUBLE_VALUE), (MutationContext)Matchers.eq((Object)MutationContext.STATIC));
        ((ShapeViewHandler)Mockito.verify(this.viewHandler, (VerificationMode)Mockito.times((int)1))).applyTitle((String)Matchers.eq((Object)"newTitle"), (MutationContext)Matchers.eq((Object)MutationContext.STATIC));
        ((ShapeViewHandler)Mockito.verify(this.viewHandler, (VerificationMode)Mockito.times((int)1))).applyFont((String)Matchers.eq((Object)COLOR), (String)Matchers.eq((Object)COLOR), (String)Matchers.eq((Object)COLOR2), (Double)Matchers.eq((Object)DOUBLE_VALUE), (Double)Matchers.eq((Object)DOUBLE_VALUE), Double.valueOf(Matchers.eq((double)1.0)), (HasTitle.Position)Matchers.eq((Object)HasTitle.Position.BOTTOM), (Double)Matchers.eq((Object)DOUBLE_VALUE), (MutationContext)Matchers.eq((Object)MutationContext.STATIC));
    }
}

