/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.impl;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeStateHelper;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ShapeStateHelperTest {
    private static final String STROKE_COLOR_0 = "sc0";
    private static final double STROKE_WIDTH_0 = 12.0;
    private static final double STROKE_ALPHA_0 = 0.1;
    @Mock
    Shape<ShapeView> shape;
    @Mock
    ShapeView shapeView;
    private ShapeStateHelper<ShapeView, Shape<ShapeView>> tested;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.shapeView.getStrokeColor()).thenReturn((Object)STROKE_COLOR_0);
        Mockito.when((Object)this.shapeView.getStrokeAlpha()).thenReturn((Object)0.1);
        Mockito.when((Object)this.shapeView.getStrokeWidth()).thenReturn((Object)12.0);
        Mockito.when((Object)this.shape.getShapeView()).thenReturn((Object)this.shapeView);
        this.tested = new ShapeStateHelper(this.shape);
        this.tested.save(arg_0 -> ShapeState.NONE.equals(arg_0));
    }

    @Test
    public void testApplySelectedState() {
        this.testApplyState(ShapeState.SELECTED);
    }

    @Test
    public void testApplyInvalidState() {
        this.testApplyState(ShapeState.INVALID);
    }

    @Test
    public void testApplyHighlightdState() {
        this.testApplyState(ShapeState.HIGHLIGHT);
    }

    @Test
    public void testApplyNoneState() {
        this.testApplyState(ShapeState.SELECTED);
        this.tested.applyState(ShapeState.NONE);
        ((ShapeView)Mockito.verify((Object)this.shapeView, (VerificationMode)Mockito.times((int)1))).setStrokeColor((String)Matchers.eq((Object)STROKE_COLOR_0));
        ((ShapeView)Mockito.verify((Object)this.shapeView, (VerificationMode)Mockito.times((int)1))).setStrokeWidth(Matchers.eq((double)12.0));
        ((ShapeView)Mockito.verify((Object)this.shapeView, (VerificationMode)Mockito.times((int)1))).setStrokeAlpha(Matchers.eq((double)0.1));
    }

    private void testApplyState(ShapeState state) {
        this.tested.applyState(state);
        ((ShapeView)Mockito.verify((Object)this.shapeView, (VerificationMode)Mockito.times((int)1))).setStrokeColor((String)Matchers.eq((Object)state.getColor()));
        ((ShapeView)Mockito.verify((Object)this.shapeView, (VerificationMode)Mockito.times((int)1))).setStrokeWidth(Matchers.eq((double)24.0));
        ((ShapeView)Mockito.verify((Object)this.shapeView, (VerificationMode)Mockito.times((int)1))).setStrokeAlpha(Matchers.eq((double)1.0));
    }
}

