/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.ShapeViewExtStub;
import org.kie.workbench.common.stunner.core.client.shape.ShapeViewStub;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeViewHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.HasFillGradient;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ShapeViewHandlerTest {
    private static final String COLOR = "#AABBCC";
    private static final Double DOUBLE_VALUE = 0.2;
    ShapeView view;
    ShapeViewExtStub viewExt;
    private ShapeViewHandler<ShapeView> tested;
    private ShapeViewHandler<ShapeViewExtStub> testedExt;

    @Before
    public void setup() throws Exception {
        this.view = (ShapeView)Mockito.spy((Object)new ShapeViewStub());
        this.viewExt = (ShapeViewExtStub)Mockito.spy((Object)new ShapeViewExtStub());
        this.tested = new ShapeViewHandler(this.view);
        this.testedExt = new ShapeViewHandler((ShapeView)this.viewExt);
        Assert.assertEquals((Object)this.view, (Object)this.tested.getShapeView());
        Assert.assertEquals((Object)this.viewExt, (Object)this.testedExt.getShapeView());
    }

    @Test
    public void testApplyFillColorNone() {
        this.tested.applyFillColor("", MutationContext.STATIC);
        ((ShapeView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFillColor(Matchers.anyString());
        ((ShapeViewExtStub)Mockito.verify((Object)this.viewExt, (VerificationMode)Mockito.times((int)0))).setFillGradient((HasFillGradient.Type)Matchers.any(HasFillGradient.Type.class), Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void testApplyFillColor() {
        this.tested.applyFillColor(COLOR, MutationContext.STATIC);
        ((ShapeView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setFillColor((String)Matchers.eq((Object)COLOR));
        ((ShapeViewExtStub)Mockito.verify((Object)this.viewExt, (VerificationMode)Mockito.times((int)0))).setFillGradient((HasFillGradient.Type)Matchers.any(HasFillGradient.Type.class), Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void testApplyFillGradient() {
        this.testedExt.applyFillColor(COLOR, MutationContext.STATIC);
        ((ShapeViewExtStub)Mockito.verify((Object)this.viewExt, (VerificationMode)Mockito.times((int)1))).setFillGradient((HasFillGradient.Type)Matchers.eq((Object)HasFillGradient.Type.LINEAR), (String)Matchers.eq((Object)COLOR), (String)Matchers.eq((Object)"#FFFFFF"));
        ((ShapeView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFillColor(Matchers.anyString());
    }

    @Test
    public void applyFillAlphaNone() {
        this.tested.applyFillAlpha(null, MutationContext.STATIC);
        ((ShapeView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFillAlpha(Matchers.anyDouble());
    }

    @Test
    public void applyFillAlpha() {
        this.tested.applyFillAlpha(DOUBLE_VALUE, MutationContext.STATIC);
        ((ShapeView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setFillAlpha(((Double)Matchers.eq((Object)DOUBLE_VALUE)).doubleValue());
    }

    @Test
    public void applyBorderAlphaNone() {
        this.tested.applyBorderAlpha(null, MutationContext.STATIC);
        ((ShapeView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setStrokeAlpha(Matchers.anyDouble());
    }

    @Test
    public void applyBorderAlpha() {
        this.tested.applyBorderAlpha(DOUBLE_VALUE, MutationContext.STATIC);
        ((ShapeView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setStrokeAlpha(((Double)Matchers.eq((Object)DOUBLE_VALUE)).doubleValue());
    }

    @Test
    public void applyBordersNone() {
        this.tested.applyBorders(null, null, MutationContext.STATIC);
        ((ShapeView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setStrokeColor(Matchers.anyString());
        ((ShapeView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setStrokeWidth(Matchers.anyDouble());
    }

    @Test
    public void applyBorders() {
        this.tested.applyBorders(COLOR, DOUBLE_VALUE, MutationContext.STATIC);
        ((ShapeView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setStrokeColor((String)Matchers.eq((Object)COLOR));
        ((ShapeView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setStrokeWidth(((Double)Matchers.eq((Object)DOUBLE_VALUE)).doubleValue());
    }

    @Test
    public void applyFontNone() {
        this.testedExt.applyFont(null, null, null, null, null, null, null, null, MutationContext.STATIC);
        ((ShapeViewExtStub)Mockito.verify((Object)this.viewExt, (VerificationMode)Mockito.times((int)0))).setTitleFontFamily(Matchers.anyString());
        ((ShapeViewExtStub)Mockito.verify((Object)this.viewExt, (VerificationMode)Mockito.times((int)0))).setTitleFontColor(Matchers.anyString());
        ((ShapeViewExtStub)Mockito.verify((Object)this.viewExt, (VerificationMode)Mockito.times((int)0))).setTitleStrokeColor(Matchers.anyString());
        ((ShapeViewExtStub)Mockito.verify((Object)this.viewExt, (VerificationMode)Mockito.times((int)0))).setTitleFontSize(Matchers.anyDouble());
        ((ShapeViewExtStub)Mockito.verify((Object)this.viewExt, (VerificationMode)Mockito.times((int)0))).setTitleStrokeWidth(Matchers.anyDouble());
        ((ShapeViewExtStub)Mockito.verify((Object)this.viewExt, (VerificationMode)Mockito.times((int)0))).setTitleAlpha(Matchers.anyDouble());
        ((ShapeViewExtStub)Mockito.verify((Object)this.viewExt, (VerificationMode)Mockito.times((int)0))).setTitlePosition((HasTitle.Position)Matchers.any(HasTitle.Position.class));
        ((ShapeViewExtStub)Mockito.verify((Object)this.viewExt, (VerificationMode)Mockito.times((int)0))).setTitleRotation(Matchers.anyDouble());
    }

    @Test
    public void applyFont() {
        this.testedExt.applyFont("family", "fontColor", COLOR, DOUBLE_VALUE, Double.valueOf(0.3), Double.valueOf(0.4), HasTitle.Position.BOTTOM, Double.valueOf(90.0), MutationContext.STATIC);
        ((ShapeViewExtStub)Mockito.verify((Object)this.viewExt, (VerificationMode)Mockito.times((int)1))).setTitleFontFamily((String)Matchers.eq((Object)"family"));
        ((ShapeViewExtStub)Mockito.verify((Object)this.viewExt, (VerificationMode)Mockito.times((int)1))).setTitleFontColor((String)Matchers.eq((Object)"fontColor"));
        ((ShapeViewExtStub)Mockito.verify((Object)this.viewExt, (VerificationMode)Mockito.times((int)1))).setTitleStrokeColor((String)Matchers.eq((Object)COLOR));
        ((ShapeViewExtStub)Mockito.verify((Object)this.viewExt, (VerificationMode)Mockito.times((int)1))).setTitleFontSize((Double)Matchers.eq((Object)DOUBLE_VALUE));
        ((ShapeViewExtStub)Mockito.verify((Object)this.viewExt, (VerificationMode)Mockito.times((int)1))).setTitleStrokeWidth(Matchers.eq((double)0.3));
        ((ShapeViewExtStub)Mockito.verify((Object)this.viewExt, (VerificationMode)Mockito.times((int)1))).setTitleAlpha(Matchers.eq((double)0.4));
        ((ShapeViewExtStub)Mockito.verify((Object)this.viewExt, (VerificationMode)Mockito.times((int)1))).setTitlePosition((HasTitle.Position)Matchers.eq((Object)HasTitle.Position.BOTTOM));
        ((ShapeViewExtStub)Mockito.verify((Object)this.viewExt, (VerificationMode)Mockito.times((int)1))).setTitleRotation(90.0);
    }

    @Test
    public void applySize() {
        this.testedExt.applySize(100.0, 200.0, MutationContext.STATIC);
        ((ShapeViewExtStub)Mockito.verify((Object)this.viewExt, (VerificationMode)Mockito.times((int)1))).setSize(Matchers.eq((double)100.0), Matchers.eq((double)200.0));
    }

    @Test
    public void applyRadius() {
        this.testedExt.applyRadius(50.0, MutationContext.STATIC);
        ((ShapeViewExtStub)Mockito.verify((Object)this.viewExt, (VerificationMode)Mockito.times((int)1))).setRadius(Matchers.eq((double)50.0));
    }
}

