/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.Optional;
import java.util.function.Consumer;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddCanvasConnectorCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetCanvasConnectionCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

public class CloneConnectorCommand
extends AbstractCanvasGraphCommand {
    private final String sourceUUID;
    private final String targetUUID;
    private final Edge candidate;
    private final String shapeSetId;
    private final Optional<Consumer<Edge>> callback;
    private transient CompositeCommand<AbstractCanvasHandler, CanvasViolation> command;

    public CloneConnectorCommand(Edge candidate, String sourceUUID, String targetUUID, String shapeSetId, Consumer<Edge> callback) {
        this.candidate = candidate;
        this.sourceUUID = sourceUUID;
        this.targetUUID = targetUUID;
        this.shapeSetId = shapeSetId;
        this.callback = Optional.ofNullable(callback);
        this.command = this.buildCommand();
    }

    private CompositeCommand<AbstractCanvasHandler, CanvasViolation> buildCommand() {
        return new CompositeCommand.Builder().reverse().build();
    }

    @Override
    protected Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler context) {
        return new org.kie.workbench.common.stunner.core.graph.command.impl.CloneConnectorCommand(this.candidate, this.sourceUUID, this.targetUUID, this.getCloneCallback());
    }

    protected Consumer<Edge> getCloneCallback() {
        return edge -> {
            if (!this.command.isEmpty()) {
                this.command = this.buildCommand();
            }
            this.command.addCommand((Command)new AddCanvasConnectorCommand((Edge)edge, this.shapeSetId));
            this.command.addCommand((Command)new SetCanvasConnectionCommand((Edge<? extends ViewConnector<?>, Node>)edge));
            this.callback.ifPresent(c -> c.accept(edge));
        };
    }

    @Override
    protected Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler context) {
        return this.command;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [candidate=" + CloneConnectorCommand.toUUID(this.candidate) + ",source=" + this.sourceUUID + ",target=" + this.targetUUID + ",shapeSet=" + this.shapeSetId + "]";
    }
}

