/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.Collection;
import java.util.function.Consumer;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddChildNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddConnectorCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddControlPointCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddDockedNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.ClearCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.CloneConnectorCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.CloneNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteConnectorCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteControlPointCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteElementsCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DockNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DrawCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.MorphNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.RemoveChildrenCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetChildrenCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetConnectionSourceNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetConnectionTargetNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UnDockNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateChildrenCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateControlPointPositionCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateDockNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateDomainObjectPropertyCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateElementPositionCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateElementPropertyCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.definition.morph.MorphDefinition;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ChildrenTraverseProcessor;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ViewTraverseProcessor;

public abstract class DefaultCanvasCommandFactory
implements CanvasCommandFactory<AbstractCanvasHandler> {
    private final ManagedInstance<ChildrenTraverseProcessor> childrenTraverseProcessors;
    private final ManagedInstance<ViewTraverseProcessor> viewTraverseProcessors;

    protected DefaultCanvasCommandFactory(ManagedInstance<ChildrenTraverseProcessor> childrenTraverseProcessors, ManagedInstance<ViewTraverseProcessor> viewTraverseProcessors) {
        this.childrenTraverseProcessors = childrenTraverseProcessors;
        this.viewTraverseProcessors = viewTraverseProcessors;
    }

    public CanvasCommand<AbstractCanvasHandler> addNode(Node candidate, String shapeSetId) {
        return new AddNodeCommand(candidate, shapeSetId);
    }

    public CanvasCommand<AbstractCanvasHandler> addChildNode(Node parent, Node candidate, String shapeSetId) {
        return new AddChildNodeCommand(parent, candidate, shapeSetId);
    }

    public CanvasCommand<AbstractCanvasHandler> addDockedNode(Node parent, Node candidate, String shapeSetId) {
        return new AddDockedNodeCommand(parent, candidate, shapeSetId);
    }

    public CanvasCommand<AbstractCanvasHandler> deleteNode(Node candidate) {
        return new DeleteNodeCommand(candidate);
    }

    public CanvasCommand<AbstractCanvasHandler> delete(Collection<Element> candidates) {
        return new DeleteElementsCommand(candidates);
    }

    public CanvasCommand<AbstractCanvasHandler> addConnector(Node sourceNode, Edge candidate, Connection connection, String shapeSetId) {
        return new AddConnectorCommand(sourceNode, candidate, connection, shapeSetId);
    }

    public CanvasCommand<AbstractCanvasHandler> deleteConnector(Edge candidate) {
        return new DeleteConnectorCommand(candidate);
    }

    public CanvasCommand<AbstractCanvasHandler> setChildNode(Node parent, Node candidate) {
        return new SetChildrenCommand(parent, candidate);
    }

    public CanvasCommand<AbstractCanvasHandler> removeChild(Node parent, Node candidate) {
        return new RemoveChildrenCommand(parent, candidate);
    }

    public CanvasCommand<AbstractCanvasHandler> updateChildNode(Node parent, Node candidate) {
        return new UpdateChildrenCommand(parent, candidate);
    }

    public CanvasCommand<AbstractCanvasHandler> updateChildren(Node parent, Collection<Node> candidates) {
        return new UpdateChildrenCommand(parent, candidates);
    }

    public CanvasCommand<AbstractCanvasHandler> dockNode(Node parent, Node candidate) {
        return new DockNodeCommand(parent, candidate);
    }

    public CanvasCommand<AbstractCanvasHandler> unDockNode(Node parent, Node candidate) {
        return new UnDockNodeCommand(parent, candidate);
    }

    public CanvasCommand<AbstractCanvasHandler> updateDockNode(Node parent, Node candidate) {
        return new UpdateDockNodeCommand(parent, candidate);
    }

    public CanvasCommand<AbstractCanvasHandler> updateDockNode(Node parent, Node candidate, boolean adjustPosition) {
        return new UpdateDockNodeCommand(parent, candidate, adjustPosition);
    }

    public CanvasCommand<AbstractCanvasHandler> draw() {
        return new DrawCanvasCommand(this.newChildrenTraverseProcessor(), this.newViewTraverseProcessor());
    }

    public CanvasCommand<AbstractCanvasHandler> morphNode(Node<? extends Definition<?>, Edge> candidate, MorphDefinition morphDefinition, String morphTarget, String shapeSetId) {
        return new MorphNodeCommand(candidate, morphDefinition, morphTarget, shapeSetId);
    }

    public CanvasCommand<AbstractCanvasHandler> setSourceNode(Node<? extends View<?>, Edge> node, Edge<? extends ViewConnector<?>, Node> edge, Connection connection) {
        return new SetConnectionSourceNodeCommand(node, edge, connection);
    }

    public CanvasCommand<AbstractCanvasHandler> setTargetNode(Node<? extends View<?>, Edge> node, Edge<? extends ViewConnector<?>, Node> edge, Connection connection) {
        return new SetConnectionTargetNodeCommand(node, edge, connection);
    }

    public CanvasCommand<AbstractCanvasHandler> updatePosition(Node<View<?>, Edge> element, Point2D location) {
        return new UpdateElementPositionCommand(element, location);
    }

    public CanvasCommand<AbstractCanvasHandler> updatePropertyValue(Element element, String propertyId, Object value) {
        return new UpdateElementPropertyCommand(element, propertyId, value);
    }

    public CanvasCommand<AbstractCanvasHandler> updateDomainObjectPropertyValue(DomainObject domainObject, String propertyId, Object value) {
        return new UpdateDomainObjectPropertyCommand(domainObject, propertyId, value);
    }

    public CanvasCommand<AbstractCanvasHandler> clearCanvas() {
        return new ClearCommand();
    }

    public CanvasCommand<AbstractCanvasHandler> cloneNode(Node candidate, String parentUuid, Point2D cloneLocation, Consumer<Node> cloneNodeCallback) {
        return new CloneNodeCommand(candidate, parentUuid, cloneLocation, cloneNodeCallback, this.childrenTraverseProcessors);
    }

    public CanvasCommand<AbstractCanvasHandler> cloneConnector(Edge candidate, String sourceUUID, String targetUUID, String shapeSetId, Consumer<Edge> callback) {
        return new CloneConnectorCommand(candidate, sourceUUID, targetUUID, shapeSetId, callback);
    }

    public CanvasCommand<AbstractCanvasHandler> addControlPoint(Edge candidate, ControlPoint controlPoint, int index) {
        return new AddControlPointCommand(candidate, controlPoint, index);
    }

    public CanvasCommand<AbstractCanvasHandler> deleteControlPoint(Edge candidate, int index) {
        return new DeleteControlPointCommand(candidate, index);
    }

    public CanvasCommand<AbstractCanvasHandler> updateControlPointPosition(Edge candidate, ControlPoint[] controlPoints) {
        return new UpdateControlPointPositionCommand(candidate, controlPoints);
    }

    protected ChildrenTraverseProcessor newChildrenTraverseProcessor() {
        return (ChildrenTraverseProcessor)this.childrenTraverseProcessors.get();
    }

    protected ViewTraverseProcessor newViewTraverseProcessor() {
        return (ViewTraverseProcessor)this.viewTraverseProcessors.get();
    }

    protected ManagedInstance<ChildrenTraverseProcessor> getChildrenTraverseProcessors() {
        return this.childrenTraverseProcessors;
    }
}

