/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.List;
import java.util.Optional;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.shape.EdgeShape;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.definition.morph.MorphDefinition;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

public class MorphCanvasNodeCommand
extends AbstractCanvasCommand {
    private Node<? extends Definition<?>, Edge> candidate;
    private MorphDefinition morphDefinition;
    private String shapeSetId;

    public MorphCanvasNodeCommand(Node<? extends Definition<?>, Edge> candidate, MorphDefinition morphDefinition, String shapeSetId) {
        this.candidate = candidate;
        this.morphDefinition = morphDefinition;
        this.shapeSetId = shapeSetId;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        Optional dockParentOptional = GraphUtils.getDockParent(this.candidate);
        Optional<Node> parentOptional = this.getParent();
        if (dockParentOptional.isPresent()) {
            context.undock((Element)dockParentOptional.get(), (Element)this.candidate);
        } else {
            parentOptional.ifPresent(parent -> context.removeChild((Element)parent, (Element)this.candidate));
        }
        GraphUtils.getDockedNodes(this.candidate).stream().forEach(node -> context.undock((Element)this.candidate, (Element)node));
        GraphUtils.getChildNodes(this.candidate).stream().forEach(node -> context.removeChild((Element)this.candidate, (Element)node));
        context.deregister((Element)this.candidate);
        context.register(this.shapeSetId, (Element<View<?>>)this.candidate);
        context.applyElementMutation((Element)this.candidate, MutationContext.STATIC);
        this.updateConnectionEdges(context, this.candidate);
        GraphUtils.getDockedNodes(this.candidate).stream().forEach(node -> context.dock((Element)this.candidate, (Element)node));
        GraphUtils.getChildNodes(this.candidate).stream().forEach(node -> context.removeChild((Element)this.candidate, (Element)node));
        if (dockParentOptional.isPresent()) {
            context.dock((Element)dockParentOptional.get(), (Element)this.candidate);
        } else {
            parentOptional.ifPresent(parent -> context.addChild((Element)parent, (Element)this.candidate));
        }
        return this.buildResult();
    }

    private void updateConnectionEdges(AbstractCanvasHandler context, Node<? extends Definition<?>, Edge> candidate) {
        Optional.ofNullable(candidate.getInEdges()).ifPresent(edges -> edges.stream().filter(this::isViewEdge).forEach(edge -> this.updateConnections(context, (Edge)edge, edge.getSourceNode(), candidate)));
        Optional.ofNullable(candidate.getOutEdges()).ifPresent(edges -> edges.stream().filter(this::isViewEdge).forEach(edge -> this.updateConnections(context, (Edge)edge, candidate, edge.getTargetNode())));
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return this.execute(context);
    }

    private void updateConnections(AbstractCanvasHandler context, Edge edge, Node sourceNode, Node targetNode) {
        if (null != edge && null != sourceNode && null != targetNode) {
            EdgeShape edgeShape = (EdgeShape)context.getCanvas().getShape(edge.getUUID());
            Shape sourceNodeShape = context.getCanvas().getShape(sourceNode.getUUID());
            Shape targetNodeShape = context.getCanvas().getShape(targetNode.getUUID());
            edgeShape.applyConnections(edge, sourceNodeShape.getShapeView(), targetNodeShape.getShapeView(), MutationContext.STATIC);
        }
    }

    private Optional<Node> getParent() {
        List inEdges = this.candidate.getInEdges();
        if (null != inEdges && !inEdges.isEmpty()) {
            for (Edge edge : inEdges) {
                if (!this.isChildEdge(edge) && !this.isDockEdge(edge)) continue;
                return Optional.ofNullable(edge.getSourceNode());
            }
        }
        return Optional.empty();
    }

    private boolean isChildEdge(Edge edge) {
        return edge.getContent() instanceof Child;
    }

    private boolean isDockEdge(Edge edge) {
        return edge.getContent() instanceof Dock;
    }

    private boolean isViewEdge(Edge edge) {
        return edge.getContent() instanceof View;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [parent=" + MorphCanvasNodeCommand.toUUID(this.getParent().orElse(null)) + ",candidate=" + MorphCanvasNodeCommand.toUUID(this.candidate) + ",shapeSet=" + this.shapeSetId + "]";
    }
}

