/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.toolbox.actions;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.toolbox.Toolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxView;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.graph.Element;

public class ActionsToolbox<V extends ActionsToolboxView<?>>
implements Toolbox<ActionsToolbox>,
Iterable<ToolboxAction> {
    private final List<ToolboxAction> actions = new LinkedList<ToolboxAction>();
    private final Supplier<AbstractCanvasHandler> canvasHandlerSupplier;
    private final String uuid;
    private final V view;

    public ActionsToolbox(Supplier<AbstractCanvasHandler> canvasHandlerSupplier, Element<?> element, V view) {
        this.uuid = element.getUUID();
        this.view = view;
        this.canvasHandlerSupplier = canvasHandlerSupplier;
    }

    public ActionsToolbox<V> init() {
        this.getView().init(this);
        this.actions.forEach(this::addButton);
        return this;
    }

    public ActionsToolbox add(ToolboxAction<AbstractCanvasHandler> action) {
        this.actions.add(action);
        return this;
    }

    @Override
    public Iterator<ToolboxAction> iterator() {
        return this.actions.iterator();
    }

    public int size() {
        return this.actions.size();
    }

    public String getElementUUID() {
        return this.uuid;
    }

    public AbstractCanvas getCanvas() {
        return this.canvasHandlerSupplier.get().getAbstractCanvas();
    }

    public Shape<?> getShape() {
        return this.canvasHandlerSupplier.get().getCanvas().getShape(this.uuid);
    }

    public ActionsToolbox show() {
        this.getView().show();
        return this;
    }

    public ActionsToolbox hide() {
        this.getView().hide();
        return this;
    }

    public void destroy() {
        this.getView().destroy();
        this.actions.clear();
    }

    public void hideAndDestroy() {
        this.getView().hideAndDestroy();
        this.actions.clear();
    }

    public V getView() {
        return this.view;
    }

    private void addButton(ToolboxAction<AbstractCanvasHandler> action) {
        AbstractCanvasHandler canvasHandler = this.canvasHandlerSupplier.get();
        this.getView().addButton(action.getGlyph(canvasHandler, this.uuid), action.getTitle(canvasHandler, this.uuid), event -> action.onMouseClick(canvasHandler, this.uuid, (MouseClickEvent)event));
    }
}

