/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.definition.adapter.binding;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.errai.databinding.client.BindableProxy;
import org.jboss.errai.databinding.client.HasProperties;
import org.jboss.errai.databinding.client.NonExistingPropertyException;
import org.jboss.errai.databinding.client.api.DataBinder;

public class ClientBindingUtils {
    private static Logger LOGGER = Logger.getLogger(ClientBindingUtils.class.getName());

    public static <T, R> R getProxiedValue(T pojo, String fieldName) {
        Object result = null;
        if (null != pojo && null != fieldName) {
            HasProperties hasProperties = (HasProperties)DataBinder.forModel(pojo).getModel();
            result = hasProperties.get(fieldName);
        }
        return (R)result;
    }

    public static <T, R> Set<R> getProxiedSet(T pojo, Collection<String> fieldNames) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        if (null != pojo && null != fieldNames && !fieldNames.isEmpty()) {
            for (String fieldName : fieldNames) {
                HasProperties hasProperties = (HasProperties)DataBinder.forModel(pojo).getModel();
                result.add(hasProperties.get(fieldName));
            }
        }
        return result;
    }

    public static <T, V> void setProxiedValue(T pojo, String fieldName, V value) {
        if (null != pojo && null != fieldName) {
            HasProperties hasProperties = (HasProperties)DataBinder.forModel(pojo).getModel();
            hasProperties.set(fieldName, value);
        }
    }

    public static <T> T newInstance(Class<?> pojoType) {
        if (null != pojoType) {
            return (T)DataBinder.forType(pojoType).getModel();
        }
        return null;
    }

    public static <T> T clone(T pojo) {
        if (null != pojo) {
            BindableProxy proxy = (BindableProxy)DataBinder.forModel(pojo).getModel();
            return (T)proxy.deepUnwrap();
        }
        return null;
    }

    public static <T, R> R merge(T source, R target) {
        Map propertyTypeMap;
        HasProperties hasProperties;
        if (null != source && null != (hasProperties = (HasProperties)DataBinder.forModel(source).getModel()) && null != (propertyTypeMap = hasProperties.getBeanProperties()) && !propertyTypeMap.isEmpty()) {
            HasProperties targetProperties = (HasProperties)DataBinder.forModel(target).getModel();
            for (Map.Entry entry : propertyTypeMap.entrySet()) {
                String pId = (String)entry.getKey();
                try {
                    targetProperties.set(pId, hasProperties.get(pId));
                }
                catch (NonExistingPropertyException exception) {
                    LOGGER.log(Level.INFO, "BindableAdapterUtils#merge - Skipping merge property [" + pId + "]");
                }
            }
            return target;
        }
        return null;
    }
}

