/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.ClipboardControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeysMatcher;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementsClearEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.AbstractSelectionAwareSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.CopySelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.CutSelectionSessionCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.session.command.impl.DeleteSelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.command.Command;

@Dependent
@Default
public class CutSelectionSessionCommand
extends AbstractSelectionAwareSessionCommand<EditorSession> {
    private final CopySelectionSessionCommand copySelectionSessionCommand;
    private final DeleteSelectionSessionCommand deleteSelectionSessionCommand;
    private final Event<CutSelectionSessionCommandExecutedEvent> commandExecutedEvent;
    private static Logger LOGGER = Logger.getLogger(CopySelectionSessionCommand.class.getName());
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private ClipboardControl clipboardControl;

    protected CutSelectionSessionCommand() {
        this(null, null, null, null);
    }

    @Inject
    public CutSelectionSessionCommand(CopySelectionSessionCommand copySelectionSessionCommand, DeleteSelectionSessionCommand deleteSelectionSessionCommand, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, Event<CutSelectionSessionCommandExecutedEvent> commandExecutedEvent) {
        super(true);
        this.copySelectionSessionCommand = copySelectionSessionCommand;
        this.deleteSelectionSessionCommand = deleteSelectionSessionCommand;
        this.sessionCommandManager = sessionCommandManager;
        this.commandExecutedEvent = commandExecutedEvent;
    }

    @Override
    public void bind(EditorSession session) {
        super.bind(session);
        this.copySelectionSessionCommand.bind(session);
        this.deleteSelectionSessionCommand.bind(session);
        session.getKeyboardControl().addKeyShortcutCallback(this::onKeyDownEvent);
        this.clipboardControl = session.getClipboardControl();
    }

    @Override
    public boolean accepts(ClientSession session) {
        return session instanceof EditorSession;
    }

    protected void onKeyDownEvent(KeyboardEvent.Key ... keys) {
        if (this.isEnabled()) {
            this.handleCtrlX(keys);
        }
    }

    private void handleCtrlX(KeyboardEvent.Key[] keys) {
        if (KeysMatcher.doKeysMatch(keys, KeyboardEvent.Key.CONTROL, KeyboardEvent.Key.X)) {
            this.execute();
        }
    }

    @Override
    public <V> void execute(final ClientSessionCommand.Callback<V> callback) {
        this.copySelectionSessionCommand.execute(new ClientSessionCommand.Callback<V>(){

            @Override
            public void onSuccess() {
                CutSelectionSessionCommand.this.deleteSelectionSessionCommand.execute(callback);
                Command command = CutSelectionSessionCommand.this.sessionCommandManager.getRegistry().peek();
                CutSelectionSessionCommand.this.clipboardControl.setRollbackCommand(new Command[]{command});
                CutSelectionSessionCommand.this.commandExecutedEvent.fire((Object)new CutSelectionSessionCommandExecutedEvent(CutSelectionSessionCommand.this, (EditorSession)CutSelectionSessionCommand.this.getSession()));
            }

            @Override
            public void onError(V error) {
                LOGGER.severe("Error on cut selection." + String.valueOf(error));
                callback.onError(error);
            }
        });
    }

    @Override
    protected void doDestroy() {
        super.doDestroy();
        this.clipboardControl = null;
    }

    @Override
    protected void handleCanvasSelectionEvent(CanvasSelectionEvent event) {
        if (event.getIdentifiers().isEmpty() || this.onlyCanvasRootSelected(event)) {
            this.enable(false);
        } else {
            this.enable(true);
        }
    }

    @Override
    protected void handleCanvasClearSelectionEvent(CanvasClearSelectionEvent event) {
        this.enable(false);
    }

    @Override
    protected void handleCanvasElementsClearEvent(CanvasElementsClearEvent event) {
        this.enable(false);
    }
}

