/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeysMatcher;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasCommandUndoneEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.command.util.RedoCommandHandler;

@Dependent
@Default
public class RedoSessionCommand
extends AbstractClientSessionCommand<EditorSession> {
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final RedoCommandHandler<Command<AbstractCanvasHandler, CanvasViolation>> redoCommandHandler;

    protected RedoSessionCommand() {
        this(null, null);
    }

    @Inject
    public RedoSessionCommand(@Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, RedoCommandHandler<Command<AbstractCanvasHandler, CanvasViolation>> redoCommandHandler) {
        super(false);
        this.redoCommandHandler = redoCommandHandler;
        this.sessionCommandManager = sessionCommandManager;
    }

    @Override
    public void bind(EditorSession session) {
        super.bind(session);
        session.getKeyboardControl().addKeyShortcutCallback(this::onKeyDownEvent);
    }

    @Override
    public boolean accepts(ClientSession session) {
        return session instanceof EditorSession;
    }

    void onKeyDownEvent(KeyboardEvent.Key ... keys) {
        if (this.isEnabled()) {
            this.handleCtrlShiftZ(keys);
        }
    }

    private void handleCtrlShiftZ(KeyboardEvent.Key[] keys) {
        if (KeysMatcher.doKeysMatch(keys, KeyboardEvent.Key.CONTROL, KeyboardEvent.Key.SHIFT, KeyboardEvent.Key.Z)) {
            this.execute();
        }
    }

    @Override
    public <V> void execute(ClientSessionCommand.Callback<V> callback) {
        PortablePreconditions.checkNotNull((String)"callback", callback);
        if (!this.redoCommandHandler.isEnabled()) {
            callback.onSuccess();
        }
        CommandResult result = this.redoCommandHandler.execute((Object)((EditorSession)this.getSession()).getCanvasHandler(), this.sessionCommandManager);
        this.checkState();
        if (CommandUtils.isError((CommandResult)result)) {
            callback.onError(result);
        } else {
            callback.onSuccess();
        }
        ((EditorSession)this.getSession()).getSelectionControl().clearSelection();
    }

    void onCommandExecuted(@Observes CanvasCommandExecutedEvent commandExecutedEvent) {
        PortablePreconditions.checkNotNull((String)"commandExecutedEvent", (Object)commandExecutedEvent);
        if (null != commandExecutedEvent.getCommand()) {
            this.redoCommandHandler.onCommandExecuted(commandExecutedEvent.getCommand());
        }
        this.checkState();
    }

    void onCommandUndoExecuted(@Observes CanvasCommandUndoneEvent commandUndoExecutedEvent) {
        PortablePreconditions.checkNotNull((String)"commandUndoExecutedEvent", (Object)commandUndoExecutedEvent);
        CanvasHandler canvasHandler = commandUndoExecutedEvent.getCanvasHandler();
        if (((AbstractCanvasHandler)((EditorSession)this.getSession()).getCanvasHandler()).equals(canvasHandler)) {
            if (null != commandUndoExecutedEvent.getCommand()) {
                this.redoCommandHandler.onUndoCommandExecuted(commandUndoExecutedEvent.getCommand());
            }
            this.checkState();
        }
    }

    private void checkState() {
        this.setEnabled(null != this.getSession() && this.redoCommandHandler.isEnabled());
        this.fire();
    }
}

