/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import java.util.Collection;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.client.validation.canvas.CanvasDiagramValidator;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.validation.DiagramElementViolation;
import org.kie.workbench.common.stunner.core.validation.Violation;

@Dependent
@Default
public class ValidateSessionCommand
extends AbstractClientSessionCommand<EditorSession> {
    private final CanvasDiagramValidator<AbstractCanvasHandler> validator;

    protected ValidateSessionCommand() {
        this(null);
    }

    @Inject
    public ValidateSessionCommand(CanvasDiagramValidator<AbstractCanvasHandler> validator) {
        super(true);
        this.validator = validator;
    }

    @Override
    public <V> void execute(ClientSessionCommand.Callback<V> callback) {
        PortablePreconditions.checkNotNull((String)"callback", callback);
        AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)((EditorSession)this.getSession()).getCanvasHandler();
        this.validator.validate(canvasHandler, elementViolations -> this.fireCallback((Collection<DiagramElementViolation<RuleViolation>>)elementViolations, callback));
    }

    @Override
    public boolean accepts(ClientSession session) {
        return session instanceof EditorSession;
    }

    private <V> void fireCallback(Collection<DiagramElementViolation<RuleViolation>> violations, ClientSessionCommand.Callback<V> callback) {
        boolean areViolations = violations.stream().filter(v -> Violation.Type.ERROR.equals((Object)v.getViolationType())).findAny().isPresent();
        if (!areViolations) {
            callback.onSuccess();
        } else {
            callback.onError(violations);
        }
    }
}

