/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.impl;

import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.MediatorsControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.MultipleSelection;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractSession;
import org.kie.workbench.common.stunner.core.client.session.impl.ManagedSession;
import org.kie.workbench.common.stunner.core.client.session.impl.ViewerSession;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.uberfire.mvp.Command;

@Dependent
public class DefaultViewerSession
extends ViewerSession {
    private final ManagedSession session;
    private final CanvasCommandManager<AbstractCanvasHandler> canvasCommandManager;

    @Inject
    public DefaultViewerSession(ManagedSession session, CanvasCommandManager<AbstractCanvasHandler> canvasCommandManager) {
        this.session = session;
        this.canvasCommandManager = canvasCommandManager;
    }

    @PostConstruct
    public void constructInstance() {
        this.session.onCanvasControlRegistered(this::onControlRegistered).onCanvasHandlerControlRegistered(this::onControlRegistered).onCanvasControlDestroyed(AbstractSession::onControlDestroyed).onCanvasHandlerControlDestroyed(AbstractSession::onControlDestroyed);
    }

    @Override
    public void init(Metadata metadata, Command callback) {
        this.init(s -> s.registerCanvasControl(MediatorsControl.class).registerCanvasHandlerControl(SelectionControl.class, MultipleSelection.class), metadata, callback);
    }

    public void init(Consumer<ManagedSession> sessionControls, Metadata metadata, Command callback) {
        sessionControls.accept(this.session);
        this.session.init(metadata, callback);
    }

    @Override
    public void open() {
        this.session.open();
    }

    @Override
    public void destroy() {
        this.session.destroy();
    }

    protected ManagedSession getSession() {
        return this.session;
    }

    public String getSessionUUID() {
        return this.session.getSessionUUID();
    }

    public AbstractCanvas getCanvas() {
        return this.session.getCanvas();
    }

    public AbstractCanvasHandler getCanvasHandler() {
        return this.session.getCanvasHandler();
    }

    @Override
    public CanvasCommandManager<AbstractCanvasHandler> getCommandManager() {
        return this.canvasCommandManager;
    }

    @Override
    public MediatorsControl<AbstractCanvas> getMediatorsControl() {
        return (MediatorsControl)this.session.getCanvasControl(MediatorsControl.class);
    }

    @Override
    public SelectionControl<AbstractCanvasHandler, Element> getSelectionControl() {
        return (SelectionControl)this.session.getCanvasHandlerControl(SelectionControl.class);
    }
}

