/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.Objects;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.HasGraphCommand;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

public abstract class AbstractCanvasGraphCommand
extends AbstractCanvasCommand
implements HasGraphCommand<AbstractCanvasHandler> {
    private Command<GraphCommandExecutionContext, RuleViolation> graphCommand;
    private Command<AbstractCanvasHandler, CanvasViolation> canvasCommand;

    protected abstract Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler var1);

    protected abstract Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler var1);

    public Command<GraphCommandExecutionContext, RuleViolation> getGraphCommand(AbstractCanvasHandler context) {
        if (null == this.graphCommand) {
            this.graphCommand = this.newGraphCommand(context);
        }
        return this.graphCommand;
    }

    public Command<AbstractCanvasHandler, CanvasViolation> getCanvasCommand(AbstractCanvasHandler context) {
        if (null == this.canvasCommand) {
            this.canvasCommand = this.newCanvasCommand(context);
        }
        return this.canvasCommand;
    }

    @Override
    public CommandResult<CanvasViolation> allow(AbstractCanvasHandler context) {
        CommandResult<CanvasViolation> result = this.performOperationOnGraph(context, CommandOperation.ALLOW);
        if (this.canDoNexOperation(result)) {
            return this.performOperationOnCanvas(context, CommandOperation.ALLOW);
        }
        return result;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        CommandResult<CanvasViolation> canvasResult;
        CommandResult<CanvasViolation> result = this.performOperationOnGraph(context, CommandOperation.EXECUTE);
        if (this.canDoNexOperation(result) && !this.canDoNexOperation(canvasResult = this.performOperationOnCanvas(context, CommandOperation.EXECUTE))) {
            this.performOperationOnGraph(context, CommandOperation.UNDO);
            return canvasResult;
        }
        return result;
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        CommandResult<CanvasViolation> result = this.performOperationOnGraph(context, CommandOperation.UNDO);
        if (this.canDoNexOperation(result)) {
            return this.performOperationOnCanvas(context, CommandOperation.UNDO);
        }
        return result;
    }

    protected Node<?, Edge> getNode(AbstractCanvasHandler context, String uuid) {
        return context.getGraphIndex().getNode(uuid);
    }

    private CommandResult<CanvasViolation> performOperationOnGraph(AbstractCanvasHandler context, CommandOperation op) {
        this.getCanvasCommand(context);
        GraphCommandExecutionContext graphContext = context.getGraphExecutionContext();
        if (Objects.isNull(graphContext)) {
            return CanvasCommandResultBuilder.SUCCESS;
        }
        Command<GraphCommandExecutionContext, RuleViolation> graphCommand = this.getGraphCommand(context);
        CommandResult graphResult = null;
        switch (op) {
            case ALLOW: {
                graphResult = graphCommand.allow((Object)graphContext);
                break;
            }
            case EXECUTE: {
                graphResult = graphCommand.execute((Object)graphContext);
                break;
            }
            case UNDO: {
                graphResult = graphCommand.undo((Object)graphContext);
            }
        }
        return new CanvasCommandResultBuilder((CommandResult<RuleViolation>)graphResult).build();
    }

    private CommandResult<CanvasViolation> performOperationOnCanvas(AbstractCanvasHandler context, CommandOperation op) {
        this.getGraphCommand(context);
        Command<AbstractCanvasHandler, CanvasViolation> command = this.getCanvasCommand(context);
        switch (op) {
            case ALLOW: {
                return command.allow((Object)context);
            }
            case EXECUTE: {
                return command.execute((Object)context);
            }
            case UNDO: {
                return command.undo((Object)context);
            }
        }
        return CanvasCommandResultBuilder.FAILED;
    }

    private boolean canDoNexOperation(CommandResult<CanvasViolation> result) {
        return null == result || !CommandUtils.isError(result);
    }

    private static enum CommandOperation {
        ALLOW,
        EXECUTE,
        UNDO;

    }
}

