/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.command;

import java.util.Collection;
import java.util.LinkedList;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolationImpl;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CommandResultBuilder;
import org.kie.workbench.common.stunner.core.command.impl.CommandResultImpl;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

public class CanvasCommandResultBuilder
extends CommandResultBuilder<CanvasViolation> {
    public static final CommandResult<CanvasViolation> SUCCESS = new CommandResultImpl(CommandResult.Type.INFO, new LinkedList());
    public static final CommandResult<CanvasViolation> FAILED = new CommandResultImpl(CommandResult.Type.ERROR, new LinkedList());

    public CommandResult.Type getType(CanvasViolation violation) {
        switch (violation.getViolationType()) {
            case ERROR: {
                return CommandResult.Type.ERROR;
            }
            case WARNING: {
                return CommandResult.Type.WARNING;
            }
        }
        return CommandResult.Type.INFO;
    }

    public CanvasCommandResultBuilder() {
    }

    public CanvasCommandResultBuilder(Collection<CanvasViolation> violations) {
        super(violations);
    }

    public CanvasCommandResultBuilder(CommandResult<RuleViolation> commandResult) {
        this.setType(commandResult.getType());
        Iterable violations = commandResult.getViolations();
        if (null != violations) {
            for (RuleViolation ruleViolation : violations) {
                CanvasViolation canvasViolation = CanvasViolationImpl.Builder.build(ruleViolation);
                this.addViolation(canvasViolation);
            }
        }
    }
}

