/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.drag;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxy;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxyCallback;
import org.kie.workbench.common.stunner.core.client.components.drag.NodeDragProxy;
import org.kie.workbench.common.stunner.core.client.components.drag.NodeDragProxyCallback;
import org.kie.workbench.common.stunner.core.client.components.drag.ShapeDragProxy;
import org.kie.workbench.common.stunner.core.client.shape.EdgeShape;
import org.kie.workbench.common.stunner.core.client.shape.ElementShape;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;

@Dependent
public class NodeDragProxyImpl
implements NodeDragProxy<AbstractCanvasHandler> {
    private final ShapeDragProxy<AbstractCanvas> shapeDragProxyFactory;
    private AbstractCanvasHandler canvasHandler;
    private EdgeShape transientEdgeShape;

    @Inject
    public NodeDragProxyImpl(ShapeDragProxy<AbstractCanvas> shapeDragProxyFactory) {
        this.shapeDragProxyFactory = shapeDragProxyFactory;
    }

    public DragProxy<AbstractCanvasHandler, NodeDragProxy.Item, NodeDragProxyCallback> proxyFor(AbstractCanvasHandler context) {
        this.canvasHandler = context;
        this.shapeDragProxyFactory.proxyFor((Object)context.getAbstractCanvas());
        return this;
    }

    public DragProxy<AbstractCanvasHandler, NodeDragProxy.Item, NodeDragProxyCallback> show(NodeDragProxy.Item item, int x, int y, final NodeDragProxyCallback callback) {
        this.clear();
        AbstractCanvas canvas = this.canvasHandler.getAbstractCanvas();
        final Node node = item.getNode();
        ShapeFactory nodeShapeFactory = item.getNodeShapeFactory();
        final Edge inEdge = item.getInEdge();
        final Node inEdgeSourceNode = item.getInEdgeSourceNode();
        ShapeFactory edgeShapeFactory = item.getInEdgeShapeFactory();
        final Shape nodeShape = nodeShapeFactory.newShape(((View)node.getContent()).getDefinition());
        if (nodeShape instanceof ElementShape) {
            ((ElementShape)nodeShape).applyProperties((Object)node, MutationContext.STATIC);
        }
        this.transientEdgeShape = (EdgeShape)edgeShapeFactory.newShape(((View)inEdge.getContent()).getDefinition());
        canvas.addShapeIntoView((Shape)this.transientEdgeShape);
        this.transientEdgeShape.applyProperties((Object)inEdge, MutationContext.STATIC);
        final Shape edgeSourceNodeShape = this.canvasHandler.getCanvas().getShape(inEdgeSourceNode.getUUID());
        this.shapeDragProxyFactory.show((Object)nodeShape, x, y, (Object)new DragProxyCallback(){

            public void onStart(int x, int y) {
                callback.onStart(x, y);
                this.drawEdge();
            }

            public void onMove(int x, int y) {
                callback.onMove(x, y);
                this.drawEdge();
            }

            public void onComplete(int x, int y) {
                MagnetConnection[] connections = this.createShapeConnections();
                callback.onComplete(x, y);
                callback.onComplete(x, y, (Connection)connections[0], (Connection)connections[1]);
                NodeDragProxyImpl.this.deleteTransientEdgeShape();
            }

            private void drawEdge() {
                if (inEdge.getContent() instanceof ViewConnector) {
                    ViewConnector viewConnector = (ViewConnector)inEdge.getContent();
                    MagnetConnection[] connections = this.createShapeConnections();
                    viewConnector.setSourceConnection((Connection)connections[0]);
                    viewConnector.setTargetConnection((Connection)connections[1]);
                }
                NodeDragProxyImpl.this.transientEdgeShape.applyConnections(inEdge, edgeSourceNodeShape.getShapeView(), nodeShape.getShapeView(), MutationContext.STATIC);
            }

            private MagnetConnection[] createShapeConnections() {
                return new MagnetConnection[]{MagnetConnection.Builder.forTarget((Element)inEdgeSourceNode, (Element)node), MagnetConnection.Builder.forTarget((Element)node, (Element)inEdgeSourceNode)};
            }
        });
        return this;
    }

    public void clear() {
        this.shapeDragProxyFactory.clear();
        this.deleteTransientEdgeShape();
    }

    public void destroy() {
        this.deleteTransientEdgeShape();
        this.shapeDragProxyFactory.destroy();
        this.canvasHandler = null;
    }

    private AbstractCanvas getCanvas() {
        return this.canvasHandler.getAbstractCanvas();
    }

    private void deleteTransientEdgeShape() {
        if (null != this.transientEdgeShape) {
            this.getCanvas().deleteShapeFromView((Shape)this.transientEdgeShape);
            this.transientEdgeShape = null;
        }
    }
}

