/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.layout;

import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.HasBounds;
import org.kie.workbench.common.stunner.core.graph.processing.layout.Layout;
import org.kie.workbench.common.stunner.core.graph.processing.layout.LayoutExecutor;
import org.kie.workbench.common.stunner.core.graph.processing.layout.LayoutService;

public final class LayoutHelper {
    private final LayoutService layoutService;

    @Inject
    public LayoutHelper(LayoutService layoutService) {
        this.layoutService = layoutService;
    }

    public void applyLayout(Diagram diagram, LayoutExecutor layoutExecutor) {
        this.applyLayout(diagram, layoutExecutor, false);
    }

    public void applyLayout(Diagram diagram, LayoutExecutor layoutExecutor, boolean overrideCurrentLayout) {
        Graph graph = diagram.getGraph();
        if (graph != null && (overrideCurrentLayout || !this.layoutService.hasLayoutInformation(graph))) {
            Layout layout = this.layoutService.createLayout(graph);
            layoutExecutor.applyLayout(layout, graph);
            for (Node node : graph.nodes()) {
                if (!CanvasLayoutUtils.isCanvasRoot(diagram, (Element)node) || !(node.getContent() instanceof HasBounds)) continue;
                ((HasBounds)node.getContent()).setBounds(Bounds.create((double)0.0, (double)0.0, (double)0.0, (double)0.0));
            }
        }
    }

    public LayoutService getLayoutService() {
        return this.layoutService;
    }
}

