/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.layout;

import java.util.HashMap;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.HasBounds;
import org.kie.workbench.common.stunner.core.graph.processing.layout.Layout;
import org.kie.workbench.common.stunner.core.graph.processing.layout.LayoutExecutor;
import org.kie.workbench.common.stunner.core.graph.processing.layout.VertexPosition;
import org.uberfire.workbench.events.NotificationEvent;

@Default
public final class OpenDiagramLayoutExecutor
implements LayoutExecutor {
    @Inject
    private Event<NotificationEvent> event;
    @Inject
    private ClientTranslationService translationService;

    public void applyLayout(Layout layout, Graph graph) {
        if (layout.getNodePositions().size() == 0) {
            return;
        }
        HashMap<String, Node> indexByUuid = new HashMap<String, Node>();
        for (Object n : graph.nodes()) {
            if (!(n instanceof Node)) continue;
            Node node = (Node)n;
            indexByUuid.put(node.getUUID(), node);
        }
        for (VertexPosition position : layout.getNodePositions()) {
            Node indexed = (Node)indexByUuid.get(position.getId());
            if (!(indexed.getContent() instanceof HasBounds)) continue;
            ((HasBounds)indexed.getContent()).setBounds(Bounds.create((double)position.getUpperLeft().getX(), (double)position.getUpperLeft().getY(), (double)position.getBottomRight().getX(), (double)position.getBottomRight().getY()));
        }
        this.notifyUser();
    }

    private void notifyUser() {
        String message = this.translationService.getValue("org.kie.workbench.common.stunner.core.client.diagram.automatic.layout.performed");
        this.event.fire((Object)new NotificationEvent(message, NotificationEvent.NotificationType.INFO));
    }
}

