/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.palette;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.palette.DefaultPaletteDefinition;
import org.kie.workbench.common.stunner.core.client.components.palette.DefaultPaletteDefinitionProviders;
import org.kie.workbench.common.stunner.core.client.components.palette.DefaultPaletteItem;
import org.kie.workbench.common.stunner.core.client.components.palette.PaletteDefinitionBuilder;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.i18n.StunnerTranslationService;
import org.kie.workbench.common.stunner.core.profile.DomainProfileManager;
import org.kie.workbench.common.stunner.core.registry.impl.DefinitionsCacheRegistry;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.uberfire.mvp.Command;

public abstract class AbstractPaletteDefinitionBuilder<T extends AbstractPaletteDefinitionBuilder>
implements PaletteDefinitionBuilder<AbstractCanvasHandler, DefaultPaletteDefinition> {
    protected final DefinitionUtils definitionUtils;
    protected final DomainProfileManager profileManager;
    protected final DefinitionsCacheRegistry definitionsRegistry;
    protected final StunnerTranslationService translationService;
    protected Predicate<String> itemFilter;
    protected Function<Object, String> categoryProvider;
    protected Predicate<String> categoryFilter;
    protected ItemMessageProvider itemMessageProvider;

    protected AbstractPaletteDefinitionBuilder(DefinitionUtils definitionUtils, DomainProfileManager profileManager, DefinitionsCacheRegistry definitionsRegistry, StunnerTranslationService translationService) {
        this.definitionUtils = definitionUtils;
        this.profileManager = profileManager;
        this.definitionsRegistry = definitionsRegistry;
        this.translationService = translationService;
        this.initDefaults();
    }

    public T itemFilter(Predicate<String> definitionItemFilter) {
        this.itemFilter = definitionItemFilter;
        return this.cast();
    }

    public T categoryProvider(Function<Object, String> categoryProvider) {
        this.categoryProvider = categoryProvider;
        return this.cast();
    }

    public T categoryFilter(Predicate<String> categoryFilter) {
        this.categoryFilter = categoryFilter;
        return this.cast();
    }

    public T itemMessages(ItemMessageProvider provider) {
        this.itemMessageProvider = provider;
        return this.cast();
    }

    @Override
    public void build(AbstractCanvasHandler canvasHandler, Consumer<DefaultPaletteDefinition> paletteDefinition) {
        this.build(canvasHandler.getDiagram().getMetadata(), paletteDefinition);
    }

    public Predicate<String> getItemFilter() {
        return this.itemFilter;
    }

    public Predicate<String> getCategoryFilter() {
        return this.categoryFilter;
    }

    public Function<Object, String> getCategoryProvider() {
        return this.categoryProvider;
    }

    public ItemMessageProvider getItemMessageProvider() {
        return this.itemMessageProvider;
    }

    protected abstract DefaultPaletteItem createItem(Object var1, String var2, Metadata var3, Function<String, DefaultPaletteItem> var4);

    @Override
    private void build(Metadata metadata, Consumer<DefaultPaletteDefinition> paletteDefinitionConsumer) {
        String definitionSetId = metadata.getDefinitionSetId();
        List definitions = this.profileManager.getAllDefinitions(metadata);
        if (null != definitions) {
            LinkedHashMap<String, DefaultPaletteItem> items = new LinkedHashMap<String, DefaultPaletteItem>();
            HashSet consumed = new HashSet(definitions);
            Command checkConsumedAndComplete = () -> {
                if (consumed.isEmpty()) {
                    paletteDefinitionConsumer.accept(new DefaultPaletteDefinition(items.values().stream().collect(Collectors.toList()), definitionSetId));
                }
            };
            for (String defId : definitions) {
                consumed.remove(defId);
                if (this.itemFilter.test(defId)) {
                    Object def = this.definitionsRegistry.getDefinitionById(defId);
                    this.buildItem(def, metadata, items);
                    checkConsumedAndComplete.execute();
                    continue;
                }
                checkConsumedAndComplete.execute();
            }
        }
    }

    protected void buildItem(Object definition, Metadata metadata, Map<String, DefaultPaletteItem> items) {
        String categoryId = this.categoryProvider.apply(definition);
        if (this.categoryFilter.test(categoryId)) {
            DefaultPaletteItem item = this.createItem(definition, categoryId, metadata, items::get);
            if (null != item) {
                items.put(item.getId(), item);
            }
        }
    }

    private void initDefaults() {
        ((AbstractPaletteDefinitionBuilder)((AbstractPaletteDefinitionBuilder)((AbstractPaletteDefinitionBuilder)this.itemFilter(id -> true)).categoryProvider(def -> this.getDefinitionManager().adapters().forDefinition().getCategory(def))).categoryFilter(id -> true)).itemMessages(new DefaultPaletteDefinitionProviders.DefaultItemMessageProvider(this.translationService));
    }

    protected DefinitionManager getDefinitionManager() {
        return this.definitionUtils.getDefinitionManager();
    }

    private T cast() {
        return (T)this;
    }

    public static interface ItemMessageProvider {
        public String getTitle(String var1);

        public String getDescription(String var1);
    }
}

