/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.toolbox.actions;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.AbstractActionsToolboxFactory;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxView;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.CreateConnectorToolboxAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.CreateNodeToolboxAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.FlowActionsToolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxDomainLookups;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.lookup.domain.CommonDomainLookups;
import org.kie.workbench.common.stunner.core.profile.DomainProfileManager;
import org.uberfire.mvp.Command;

@Dependent
@FlowActionsToolbox
public class FlowActionsToolboxFactory
extends AbstractActionsToolboxFactory {
    private final ToolboxDomainLookups toolboxDomainLookups;
    private final DomainProfileManager profileManager;
    private final Supplier<CreateConnectorToolboxAction> createConnectorActions;
    private final Command createConnectorActionsDestroyer;
    private final Supplier<CreateNodeToolboxAction> createNodeActions;
    private final Command createNodeActionsDestroyer;
    private final Supplier<ActionsToolboxView> views;
    private final Command viewsDestroyer;

    @Inject
    public FlowActionsToolboxFactory(ToolboxDomainLookups toolboxDomainLookups, DomainProfileManager profileManager, @Any ManagedInstance<CreateConnectorToolboxAction> createConnectorActions, @Any @FlowActionsToolbox ManagedInstance<CreateNodeToolboxAction> createNodeActions, @Any @FlowActionsToolbox ManagedInstance<ActionsToolboxView> views) {
        this(toolboxDomainLookups, profileManager, () -> createConnectorActions.get(), () -> createConnectorActions.destroyAll(), () -> createNodeActions.get(), () -> createNodeActions.destroyAll(), () -> views.get(), () -> views.destroyAll());
    }

    FlowActionsToolboxFactory(ToolboxDomainLookups toolboxDomainLookups, DomainProfileManager profileManager, Supplier<CreateConnectorToolboxAction> createConnectorActions, Command createConnectorActionsDestroyer, Supplier<CreateNodeToolboxAction> createNodeActions, Command createNodeActionsDestroyer, Supplier<ActionsToolboxView> views, Command viewsDestroyer) {
        this.toolboxDomainLookups = toolboxDomainLookups;
        this.profileManager = profileManager;
        this.createConnectorActions = createConnectorActions;
        this.createConnectorActionsDestroyer = createConnectorActionsDestroyer;
        this.createNodeActions = createNodeActions;
        this.createNodeActionsDestroyer = createNodeActionsDestroyer;
        this.views = views;
        this.viewsDestroyer = viewsDestroyer;
    }

    @Override
    protected ActionsToolboxView<?> newViewInstance() {
        return this.views.get();
    }

    @Override
    public Collection<ToolboxAction<AbstractCanvasHandler>> getActions(AbstractCanvasHandler canvasHandler, Element<?> element) {
        Diagram diagram = canvasHandler.getDiagram();
        Metadata metadata = diagram.getMetadata();
        String defSetId = metadata.getDefinitionSetId();
        LinkedHashSet actions = new LinkedHashSet();
        Node node = (Node)element;
        CommonDomainLookups lookup = this.toolboxDomainLookups.get(defSetId);
        Set targetConnectors = lookup.lookupTargetConnectors(node);
        return Stream.concat(targetConnectors.stream().map(connectorDefId -> this.createConnectorActions.get().setEdgeId((String)connectorDefId)), targetConnectors.stream().flatMap(defaultConnectorId -> {
            Predicate definitionsAllowedFilter = this.profileManager.isDefinitionIdAllowed(metadata);
            Set targets = lookup.lookupTargetNodes(diagram.getGraph(), node, defaultConnectorId, definitionsAllowedFilter);
            Set morphTargets = lookup.lookupMorphBaseDefinitions(targets);
            return morphTargets.stream().map(defId -> this.createNodeActions.get().setEdgeId((String)defaultConnectorId).setNodeId((String)defId));
        })).collect(Collectors.toList());
    }

    @PreDestroy
    public void destroy() {
        this.createConnectorActionsDestroyer.execute();
        this.createNodeActionsDestroyer.execute();
        this.viewsDestroyer.execute();
    }
}

