/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command;

import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.AbstractCanvasHandlerEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.impl.InstanceUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.uberfire.mvp.Command;

public abstract class AbstractClientSessionCommand<S extends ClientSession>
implements ClientSessionCommand<S> {
    private static Logger LOGGER = Logger.getLogger(AbstractClientSessionCommand.class.getName());
    private S session;
    private Command statusCallback;
    private boolean enabled;

    public AbstractClientSessionCommand(boolean enabled) {
        this.enabled = enabled;
    }

    public void bind(S session) {
        this.session = session;
    }

    protected CanvasCommandFactory<AbstractCanvasHandler> loadCanvasFactory(ManagedInstance<CanvasCommandFactory<AbstractCanvasHandler>> canvasCommandFactoryInstance, DefinitionUtils definitionUtils) {
        Diagram diagram = this.session.getCanvasHandler().getDiagram();
        String id = diagram.getMetadata().getDefinitionSetId();
        Annotation qualifier = definitionUtils.getQualifier(id);
        return InstanceUtils.lookup(canvasCommandFactoryInstance, qualifier);
    }

    public abstract boolean accepts(ClientSession var1);

    @Override
    public ClientSessionCommand<S> listen(Command statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public void execute() {
        this.execute(new ClientSessionCommand.Callback<Object>(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onError(Object error) {
                LOGGER.log(Level.SEVERE, error.toString());
            }
        });
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public final void destroy() {
        this.doDestroy();
        this.enabled = false;
        this.session = null;
        this.statusCallback = null;
    }

    protected void doDestroy() {
    }

    protected void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected void enable(boolean enable) {
        this.setEnabled(enable);
        this.fire();
    }

    protected void fire() {
        if (null != this.statusCallback) {
            this.statusCallback.execute();
        }
    }

    protected S getSession() {
        return this.session;
    }

    protected Element<? extends View<?>> getElement(String uuid) {
        AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)this.getSession().getCanvasHandler();
        return canvasHandler.getGraphIndex().get(uuid);
    }

    protected AbstractCanvasHandler getCanvasHandler() {
        return (AbstractCanvasHandler)this.getSession().getCanvasHandler();
    }

    protected ClientSessionCommand.Callback<Throwable> newDefaultCallback(final String errorMessage) {
        return new ClientSessionCommand.Callback<Throwable>(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onError(Throwable error) {
                LOGGER.log(Level.SEVERE, errorMessage + " Details: " + error.toString());
            }
        };
    }

    protected boolean checkEventContext(AbstractCanvasHandlerEvent canvasHandlerEvent) {
        CanvasHandler _canvasHandler = canvasHandlerEvent.getCanvasHandler();
        return null != this.getSession() && this.getSession().getCanvasHandler() != null && this.getSession().getCanvasHandler().equals(_canvasHandler);
    }
}

