/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeysMatcher;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.RegisterChangedEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;

@Dependent
@Default
public class UndoSessionCommand
extends AbstractClientSessionCommand<EditorSession> {
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;

    @Inject
    public UndoSessionCommand(@Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager) {
        super(false);
        this.sessionCommandManager = sessionCommandManager;
    }

    @Override
    public void bind(EditorSession session) {
        super.bind(session);
        session.getKeyboardControl().addKeyShortcutCallback(this::onKeyDownEvent);
    }

    @Override
    public boolean accepts(ClientSession session) {
        return session instanceof EditorSession;
    }

    void onKeyDownEvent(KeyboardEvent.Key ... keys) {
        if (this.isEnabled()) {
            this.handleCtrlZ(keys);
        }
    }

    private void handleCtrlZ(KeyboardEvent.Key[] keys) {
        if (KeysMatcher.doKeysMatch(keys, KeyboardEvent.Key.CONTROL, KeyboardEvent.Key.Z)) {
            this.execute();
        }
    }

    @Override
    public <V> void execute(ClientSessionCommand.Callback<V> callback) {
        PortablePreconditions.checkNotNull((String)"callback", callback);
        SessionCommandManager<AbstractCanvasHandler> scm = this.getSessionCommandManager();
        if (null != scm) {
            CommandResult result = this.getSessionCommandManager().undo((Object)((EditorSession)this.getSession()).getCanvasHandler());
            this.checkState();
            if (CommandUtils.isError((CommandResult)result)) {
                callback.onError(result);
                this.getSessionCommandManager().getRegistry().clear();
            } else {
                callback.onSuccess();
            }
            ((EditorSession)this.getSession()).getSelectionControl().clearSelection();
        }
    }

    void onCommandAdded(@Observes RegisterChangedEvent registerChangedEvent) {
        PortablePreconditions.checkNotNull((String)"registerChangedEvent", (Object)registerChangedEvent);
        if (registerChangedEvent.getCanvasHandler().equals(this.getCanvasHandler())) {
            this.checkState();
        }
    }

    private void checkState() {
        if (this.getSession() != null) {
            this.setEnabled(!((EditorSession)this.getSession()).getCommandRegistry().getCommandHistory().isEmpty());
            this.fire();
        }
    }

    private SessionCommandManager<AbstractCanvasHandler> getSessionCommandManager() {
        return this.sessionCommandManager;
    }
}

