/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.validation.canvas;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.validation.canvas.CanvasValidationFailEvent;
import org.kie.workbench.common.stunner.core.client.validation.canvas.CanvasValidationSuccessEvent;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.validation.DiagramElementViolation;
import org.kie.workbench.common.stunner.core.validation.DiagramValidator;
import org.kie.workbench.common.stunner.core.validation.ElementViolation;
import org.kie.workbench.common.stunner.core.validation.Violation;

@Dependent
public class CanvasDiagramValidator<H extends AbstractCanvasHandler> {
    private final DiagramValidator<Diagram, RuleViolation> diagramValidator;
    private final Event<CanvasValidationSuccessEvent> validationSuccessEvent;
    private final Event<CanvasValidationFailEvent> validationFailEvent;

    protected CanvasDiagramValidator() {
        this(null, null, null);
    }

    @Inject
    public CanvasDiagramValidator(DiagramValidator<Diagram, RuleViolation> diagramValidator, Event<CanvasValidationSuccessEvent> validationSuccessEvent, Event<CanvasValidationFailEvent> validationFailEvent) {
        this.diagramValidator = diagramValidator;
        this.validationSuccessEvent = validationSuccessEvent;
        this.validationFailEvent = validationFailEvent;
    }

    public void validate(H canvasHandler, Consumer<Collection<DiagramElementViolation<RuleViolation>>> callback) {
        this.diagramValidator.validate((Object)canvasHandler.getDiagram(), violations -> {
            this.checkViolations(canvasHandler, (Collection<DiagramElementViolation<RuleViolation>>)violations);
            callback.accept((Collection<DiagramElementViolation<RuleViolation>>)violations);
        });
    }

    /*
     * Unable to fully structure code
     */
    private void checkViolations(H canvasHandler, Collection<DiagramElementViolation<RuleViolation>> elementViolations) {
        uuid = canvasHandler.getUuid();
        diagram = canvasHandler.getDiagram();
        name = diagram.getName();
        title = diagram.getMetadata().getTitle();
        if (this.getElementViolationsStream(elementViolations).count() == 0L) ** GOTO lbl-1000
        if (this.getElementViolationsStream(elementViolations).map((Function<ElementViolation, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkViolations$1(org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler org.kie.workbench.common.stunner.core.validation.ElementViolation ), (Lorg/kie/workbench/common/stunner/core/validation/ElementViolation;)Ljava/lang/Boolean;)((CanvasDiagramValidator)this, canvasHandler)).anyMatch((Predicate<Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/lang/Boolean;)Z)((Boolean)Boolean.FALSE))) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = valid = false;
        }
        if (valid) {
            this.validationSuccessEvent.fire((Object)new CanvasValidationSuccessEvent(uuid, name, title));
        } else {
            this.validationFailEvent.fire((Object)new CanvasValidationFailEvent(uuid, name, title, elementViolations));
        }
    }

    private Stream<ElementViolation> getElementViolationsStream(Collection<DiagramElementViolation<RuleViolation>> elementViolations) {
        return elementViolations.stream().flatMap(v -> Stream.of(v.getDomainViolations(), v.getGraphViolations(), v.getModelViolations())).flatMap(Collection::stream);
    }

    private boolean applyViolation(H canvasHandler, ElementViolation violation) {
        if (this.hasViolations(violation)) {
            Shape shape = this.getShape(canvasHandler, violation.getUUID());
            if (null != shape) {
                shape.applyState(ShapeState.INVALID);
            }
            return true;
        }
        return false;
    }

    private Shape getShape(H canvasHandler, String uuid) {
        return canvasHandler.getCanvas().getShape(uuid);
    }

    private boolean hasViolations(ElementViolation violation) {
        return Violation.Type.ERROR.equals((Object)violation.getViolationType()) || Violation.Type.WARNING.equals((Object)violation.getViolationType());
    }

    private /* synthetic */ Boolean lambda$checkViolations$1(AbstractCanvasHandler canvasHandler, ElementViolation v) {
        return this.applyViolation(canvasHandler, v);
    }
}

