/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.api;

import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.api.AbstractClientSessionManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.ClientSessionFactory;
import org.kie.workbench.common.stunner.core.client.session.event.OnSessionErrorEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDestroyedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionOpenedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionPausedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionResumedEvent;
import org.kie.workbench.common.stunner.core.command.exception.CommandException;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.uberfire.commons.validation.PortablePreconditions;

@ApplicationScoped
public class ClientSessionManagerImpl
extends AbstractClientSessionManager {
    private final DefinitionUtils definitionUtils;
    private final ManagedInstance<ClientSessionFactory> sessionFactoriesInstances;
    private final Event<SessionOpenedEvent> sessionOpenedEvent;
    private final Event<SessionPausedEvent> sessionPausedEvent;
    private final Event<SessionResumedEvent> sessionResumedEvent;
    private final Event<SessionDestroyedEvent> sessionDestroyedEvent;
    private final Event<OnSessionErrorEvent> sessionErrorEvent;

    protected ClientSessionManagerImpl() {
        this(null, null, null, null, null, null, null);
    }

    @Inject
    public ClientSessionManagerImpl(DefinitionUtils definitionUtils, @Any ManagedInstance<ClientSessionFactory> sessionFactoriesInstances, Event<SessionOpenedEvent> sessionOpenedEvent, Event<SessionDestroyedEvent> sessionDestroyedEvent, Event<SessionPausedEvent> sessionPausedEvent, Event<SessionResumedEvent> sessionResumedEvent, Event<OnSessionErrorEvent> sessionErrorEvent) {
        this.definitionUtils = definitionUtils;
        this.sessionFactoriesInstances = sessionFactoriesInstances;
        this.sessionOpenedEvent = sessionOpenedEvent;
        this.sessionPausedEvent = sessionPausedEvent;
        this.sessionResumedEvent = sessionResumedEvent;
        this.sessionDestroyedEvent = sessionDestroyedEvent;
        this.sessionErrorEvent = sessionErrorEvent;
    }

    @Override
    protected <D extends Diagram> List<ClientSessionFactory<?>> getFactories(D diagram) {
        PortablePreconditions.checkNotNull((String)"diagram", diagram);
        String defSetId = diagram.getMetadata().getDefinitionSetId();
        Annotation qualifier = this.definitionUtils.getQualifier(defSetId);
        LinkedList result = new LinkedList();
        this.sessionFactoriesInstances.select(new Annotation[]{qualifier}).forEach(result::add);
        if (result.isEmpty()) {
            this.sessionFactoriesInstances.select(new Annotation[]{DefinitionManager.DEFAULT_QUALIFIER}).forEach(result::add);
        }
        return result;
    }

    @Override
    protected void postOpen() {
        this.sessionOpenedEvent.fire((Object)new SessionOpenedEvent(this.current));
    }

    @Override
    protected void postPause() {
        this.sessionPausedEvent.fire((Object)new SessionPausedEvent(this.current));
    }

    @Override
    protected void postResume() {
        this.sessionResumedEvent.fire((Object)new SessionResumedEvent(this.current));
    }

    @Override
    protected void postDestroy() {
        this.sessionDestroyedEvent.fire((Object)new SessionDestroyedEvent(this.current));
    }

    @Override
    public void handleCommandError(CommandException ce) {
        super.handleCommandError(ce);
        this.sessionErrorEvent.fire((Object)new OnSessionErrorEvent(this.current, new ClientRuntimeError("Error while executing command.", (Throwable)ce)));
    }

    @Override
    public void handleClientError(ClientRuntimeError error) {
        super.handleClientError(error);
        this.sessionErrorEvent.fire((Object)new OnSessionErrorEvent(this.current, error));
    }
}

