/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas;

import com.google.gwt.logging.client.LogConfiguration;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Event;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasGrid;
import org.kie.workbench.common.stunner.core.client.canvas.Layer;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasClearEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasDrawnEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasFocusedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasShapeAddedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasShapeRemovedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasShapeListener;
import org.kie.workbench.common.stunner.core.client.canvas.listener.HasCanvasListeners;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLoadingObserver;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.util.UUID;

public abstract class AbstractCanvas<V extends View>
implements Canvas<Shape>,
HasCanvasListeners<CanvasShapeListener> {
    private static Logger LOGGER = Logger.getLogger(AbstractCanvas.class.getName());
    protected Layer layer;
    protected V view;
    protected CanvasGrid grid;
    protected Event<CanvasClearEvent> canvasClearEvent;
    protected Event<CanvasShapeAddedEvent> canvasShapeAddedEvent;
    protected Event<CanvasShapeRemovedEvent> canvasShapeRemovedEvent;
    protected Event<CanvasDrawnEvent> canvasDrawnEvent;
    protected Event<CanvasFocusedEvent> canvasFocusedEvent;
    protected final List<Shape> shapes = new ArrayList<Shape>();
    protected final List<CanvasShapeListener> listeners = new LinkedList<CanvasShapeListener>();
    private final CanvasLoadingObserver loadingObserver = new CanvasLoadingObserver();
    private final String uuid;

    protected AbstractCanvas(Event<CanvasClearEvent> canvasClearEvent, Event<CanvasShapeAddedEvent> canvasShapeAddedEvent, Event<CanvasShapeRemovedEvent> canvasShapeRemovedEvent, Event<CanvasDrawnEvent> canvasDrawnEvent, Event<CanvasFocusedEvent> canvasFocusedEvent, Layer layer, V view) {
        this.canvasClearEvent = canvasClearEvent;
        this.canvasShapeAddedEvent = canvasShapeAddedEvent;
        this.canvasShapeRemovedEvent = canvasShapeRemovedEvent;
        this.canvasDrawnEvent = canvasDrawnEvent;
        this.canvasFocusedEvent = canvasFocusedEvent;
        this.layer = layer;
        this.view = view;
        this.uuid = UUID.uuid();
    }

    protected <P> void show(P panel, int width, int height, Layer layer) {
        this.view.show(panel, width, height, layer);
    }

    public abstract void addControl(IsWidget var1);

    public abstract void deleteControl(IsWidget var1);

    public List<Shape> getShapes() {
        return this.shapes;
    }

    public Shape getShape(String uuid) {
        if (null != this.shapes) {
            for (Shape shape : this.shapes) {
                if (!shape.getUUID().equals(uuid)) continue;
                return shape;
            }
        }
        return null;
    }

    public Canvas addChildShape(Shape parent, Shape child) {
        this.getView().addChildShape(parent.getShapeView(), child.getShapeView());
        this.log(Level.FINE, "Adding child [" + child.getUUID() + "] into parent [" + parent.getUUID() + "]");
        return this;
    }

    public Canvas deleteChildShape(Shape parent, Shape child) {
        this.getView().removeChildShape(parent.getShapeView(), child.getShapeView());
        this.log(Level.FINE, "Deleting child [" + child.getUUID() + "] from parent [" + parent.getUUID() + "]");
        return this;
    }

    public Canvas dock(Shape parent, Shape child) {
        this.getView().dock(parent.getShapeView(), child.getShapeView());
        this.log(Level.FINE, "Docking child [" + child.getUUID() + "] into parent [" + parent.getUUID() + "]");
        return this;
    }

    public Canvas undock(Shape target, Shape child) {
        this.getView().undock(target.getShapeView(), child.getShapeView());
        this.log(Level.FINE, "Undocking child [" + child.getUUID() + "] from parent [" + target.getUUID() + "]");
        return this;
    }

    public Canvas addShape(Shape shape) {
        if (!this.shapes.contains(shape)) {
            this.addTransientShape(shape);
            this.shapes.add(shape);
            this.fireCanvasShapeAdded(shape);
            this.canvasShapeAddedEvent.fire((Object)new CanvasShapeAddedEvent((Canvas)this, shape));
        }
        return this;
    }

    public Canvas addTransientShape(Shape shape) {
        if (shape.getUUID() == null) {
            shape.setUUID(UUID.uuid());
        }
        shape.getShapeView().setUUID(shape.getUUID());
        this.view.addShape(shape.getShapeView());
        return this;
    }

    public double getAbsoluteX() {
        return this.view.getAbsoluteX();
    }

    public double getAbsoluteY() {
        return this.view.getAbsoluteY();
    }

    public Canvas setGrid(CanvasGrid grid) {
        this.grid = grid;
        this.view.setGrid(grid);
        return this;
    }

    public CanvasGrid getGrid() {
        return this.grid;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public Canvas deleteShape(Shape shape) {
        this.deleteTransientShape(shape);
        this.fireCanvasShapeRemoved(shape);
        this.shapes.remove(shape);
        this.canvasShapeRemovedEvent.fire((Object)new CanvasShapeRemovedEvent((Canvas)this, shape));
        return this;
    }

    public Canvas deleteTransientShape(Shape shape) {
        this.view.removeShape(shape.getShapeView());
        shape.destroy();
        return this;
    }

    public AbstractCanvas draw() {
        this.view.getLayer().draw();
        return this;
    }

    public AbstractCanvas clear() {
        return this.clear(true);
    }

    private AbstractCanvas clear(boolean fireEvents) {
        if (!this.shapes.isEmpty()) {
            new LinkedList<Shape>(this.shapes).stream().forEach(this::deleteShape);
            this.shapes.clear();
        }
        this.fireCanvasClear();
        if (fireEvents) {
            this.canvasClearEvent.fire((Object)new CanvasClearEvent((Canvas)this));
        }
        this.view.clear();
        return this;
    }

    public void destroy() {
        this.clear(false);
        this.listeners.clear();
        this.view.destroy();
        this.layer.destroy();
        this.layer = null;
        this.view = null;
    }

    public HasCanvasListeners<CanvasShapeListener> addRegistrationListener(CanvasShapeListener instance) {
        this.listeners.add(instance);
        return this;
    }

    public HasCanvasListeners<CanvasShapeListener> removeRegistrationListener(CanvasShapeListener instance) {
        this.listeners.remove(instance);
        return this;
    }

    public HasCanvasListeners<CanvasShapeListener> clearRegistrationListeners() {
        this.listeners.clear();
        return this;
    }

    protected void fireCanvasShapeAdded(Shape shape) {
        for (CanvasShapeListener instance : this.listeners) {
            instance.register((Object)shape);
        }
    }

    protected void fireCanvasShapeRemoved(Shape shape) {
        for (CanvasShapeListener instance : this.listeners) {
            instance.deregister((Object)shape);
        }
    }

    protected void fireCanvasClear() {
        for (CanvasShapeListener instance : this.listeners) {
            instance.clear();
        }
    }

    protected void afterDrawCanvas() {
        this.canvasDrawnEvent.fire((Object)new CanvasDrawnEvent((Canvas)this));
    }

    public int getWidth() {
        return this.view.getWidth();
    }

    public int getHeight() {
        return this.view.getHeight();
    }

    public V getView() {
        return this.view;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractCanvas)) {
            return false;
        }
        AbstractCanvas that = (AbstractCanvas)o;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid == null ? 0 : ~(~this.uuid.hashCode());
    }

    public void setLoadingObserverCallback(CanvasLoadingObserver.Callback loadingObserverCallback) {
        this.loadingObserver.setLoadingObserverCallback(loadingObserverCallback);
    }

    public void loadingStarted() {
        this.loadingObserver.loadingStarted();
    }

    public void loadingCompleted() {
        this.loadingObserver.loadingCompleted();
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }

    public static interface View<P>
    extends IsWidget {
        public View show(P var1, int var2, int var3, Layer var4);

        public View add(IsWidget var1);

        public View remove(IsWidget var1);

        public View addShape(ShapeView<?> var1);

        public View removeShape(ShapeView<?> var1);

        public View addChildShape(ShapeView<?> var1, ShapeView<?> var2);

        public View removeChildShape(ShapeView<?> var1, ShapeView<?> var2);

        public View dock(ShapeView<?> var1, ShapeView<?> var2);

        public View undock(ShapeView<?> var1, ShapeView<?> var2);

        public double getAbsoluteX();

        public double getAbsoluteY();

        public int getWidth();

        public int getHeight();

        public View setGrid(CanvasGrid var1);

        public View setCursor(Cursors var1);

        public View setDecoratorStrokeWidth(double var1);

        public View setDecoratorStrokeAlpha(double var1);

        public View setDecoratorStrokeColor(String var1);

        public Layer getLayer();

        public View clear();

        public void destroy();
    }

    public static enum Cursors {
        AUTO,
        MOVE,
        POINTER,
        TEXT,
        NOT_ALLOWED,
        WAIT,
        CROSSHAIR;

    }
}

