/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasFactory;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControl;

public abstract class AbstractCanvasFactory<T extends AbstractCanvasFactory>
implements CanvasFactory<AbstractCanvas, AbstractCanvasHandler> {
    private static Logger LOGGER = Logger.getLogger(AbstractCanvasFactory.class.getName());
    private final Map<Class<? extends CanvasControl>, ManagedInstance> controls = new HashMap<Class<? extends CanvasControl>, ManagedInstance>(15);

    public T register(Class<? extends CanvasControl> controlType, ManagedInstance instances) {
        this.controls.put(controlType, instances);
        return this.cast();
    }

    public <A extends CanvasControl> A newControl(Class<A> type) {
        if (this.controls.containsKey(type)) {
            ManagedInstance mi = this.controls.get(type);
            if (!mi.isUnsatisfied()) {
                return (A)((CanvasControl)mi.get());
            }
            LOGGER.log(Level.SEVERE, "Canvas Control for type [" + type.getName() + "] is cannot be resolved by this canvas factory [" + this.getClass().getName() + "]");
        } else {
            LOGGER.log(Level.WARNING, "Canvas Control for type [" + type.getName() + "] is not supported by this canvas factory [" + this.getClass().getName() + "]");
        }
        return null;
    }

    private T cast() {
        return (T)this;
    }
}

