/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.client.api.ClientDefinitionManager;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.BaseCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProviderFactory;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementAddedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementRemovedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementUpdatedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementsClearEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.service.ClientFactoryService;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContextImpl;
import org.kie.workbench.common.stunner.core.graph.processing.index.GraphIndexBuilder;
import org.kie.workbench.common.stunner.core.graph.processing.index.Index;
import org.kie.workbench.common.stunner.core.graph.processing.index.MutableIndex;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class CanvasHandlerImpl<D extends Diagram, C extends AbstractCanvas>
extends BaseCanvasHandler<D, C> {
    private final ClientFactoryService clientFactoryServices;
    private final CanvasCommandFactory<AbstractCanvasHandler> commandFactory;
    private final GraphIndexBuilder<? extends MutableIndex<Node, Edge>> indexBuilder;
    private final RuleManager ruleManager;
    private final Event<CanvasElementAddedEvent> canvasElementAddedEvent;
    private final Event<CanvasElementRemovedEvent> canvasElementRemovedEvent;
    private final Event<CanvasElementUpdatedEvent> canvasElementUpdatedEvent;
    private final Event<CanvasElementsClearEvent> canvasElementsClearEvent;
    private MutableIndex<?, ?> graphIndex;

    @Inject
    public CanvasHandlerImpl(ClientDefinitionManager clientDefinitionManager, CanvasCommandFactory<AbstractCanvasHandler> commandFactory, ClientFactoryService clientFactoryServices, RuleManager ruleManager, GraphUtils graphUtils, GraphIndexBuilder<? extends MutableIndex<Node, Edge>> indexBuilder, ShapeManager shapeManager, TextPropertyProviderFactory textPropertyProviderFactory, Event<CanvasElementAddedEvent> canvasElementAddedEvent, Event<CanvasElementRemovedEvent> canvasElementRemovedEvent, Event<CanvasElementUpdatedEvent> canvasElementUpdatedEvent, Event<CanvasElementsClearEvent> canvasElementsClearEvent) {
        super((DefinitionManager)clientDefinitionManager, graphUtils, shapeManager, textPropertyProviderFactory);
        this.commandFactory = commandFactory;
        this.indexBuilder = indexBuilder;
        this.ruleManager = ruleManager;
        this.clientFactoryServices = clientFactoryServices;
        this.canvasElementAddedEvent = canvasElementAddedEvent;
        this.canvasElementRemovedEvent = canvasElementRemovedEvent;
        this.canvasElementUpdatedEvent = canvasElementUpdatedEvent;
        this.canvasElementsClearEvent = canvasElementsClearEvent;
    }

    @Override
    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    @Override
    public Index<?, ?> getGraphIndex() {
        return this.graphIndex;
    }

    @Override
    public GraphCommandExecutionContext getGraphExecutionContext() {
        return new GraphCommandExecutionContextImpl(this.getDefinitionManager(), this.getFactoryManager(), this.getRuleManager(), this.getGraphIndex(), this.getRuleSet());
    }

    @Override
    protected void buildGraphIndex(Command loadCallback) {
        this.graphIndex = (MutableIndex)this.getIndexBuilder().build(this.getDiagram().getGraph());
        loadCallback.execute();
    }

    @Override
    public void draw(ParameterizedCommand<CommandResult<?>> loadCallback) {
        loadCallback.execute((Object)this.commandFactory.draw().execute((Object)this));
    }

    @Override
    public void clearCanvas() {
        super.clearCanvas();
        this.canvasElementsClearEvent.fire((Object)new CanvasElementsClearEvent((CanvasHandler)this));
    }

    @Override
    protected void afterElementAdded(Element element, Shape shape) {
        this.canvasElementAddedEvent.fire((Object)new CanvasElementAddedEvent((CanvasHandler)this, element));
    }

    @Override
    protected void beforeElementDeleted(Element element, Shape shape) {
        this.canvasElementRemovedEvent.fire((Object)new CanvasElementRemovedEvent((CanvasHandler)this, element));
    }

    @Override
    protected void afterElementDeleted(Element element, Shape shape) {
    }

    @Override
    protected void beforeElementUpdated(Element element, Shape shape) {
    }

    @Override
    protected void afterElementUpdated(Element element, Shape shape) {
        this.canvasElementUpdatedEvent.fire((Object)new CanvasElementUpdatedEvent((CanvasHandler)this, element));
    }

    @Override
    protected void destroyGraphIndex(Command callback) {
        if (null != this.getGraphIndex() && this.getGraphIndex() instanceof MutableIndex) {
            ((MutableIndex)this.getGraphIndex()).clear();
        }
        callback.execute();
    }

    private GraphIndexBuilder<? extends MutableIndex<Node, Edge>> getIndexBuilder() {
        return this.indexBuilder;
    }

    private FactoryManager getFactoryManager() {
        return this.clientFactoryServices.getClientFactoryManager();
    }
}

