/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteCanvasNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.RemoveCanvasChildCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommandImpl;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class AddCanvasChildNodeCommand
extends AbstractCanvasCommand {
    private final Node parent;
    private final Node candidate;
    private final String shapeSetId;

    public AddCanvasChildNodeCommand(Node parent, Node candidate, String shapeSetId) {
        this.parent = parent;
        this.candidate = candidate;
        this.shapeSetId = shapeSetId;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        context.register(this.shapeSetId, (Element<View<?>>)this.candidate);
        context.addChild((Element)this.parent, (Element)this.candidate);
        context.applyElementMutation((Element)this.parent, MutationContext.STATIC);
        context.applyElementMutation((Element)this.candidate, MutationContext.STATIC);
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return new CompositeCommandImpl.CompositeCommandBuilder().addCommand((Command)new RemoveCanvasChildCommand(this.parent, this.candidate)).addCommand((Command)new DeleteCanvasNodeCommand(this.candidate, this.parent)).build().execute((Object)context);
    }

    public Node getParent() {
        return this.parent;
    }

    public Node getCandidate() {
        return this.candidate;
    }

    public String getShapeSetId() {
        return this.shapeSetId;
    }

    public String toString() {
        return this.getClass().getName() + " [parent=" + this.getUUID((Element<?>)this.parent) + ", candidate=" + this.getUUID((Element<?>)this.candidate) + ", shapeSet=" + this.shapeSetId + "]";
    }
}

