/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.CanvasUndockNodeCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;

public class CanvasDockNodeCommand
extends AbstractCanvasCommand {
    private final Node parent;
    private final Node candidate;

    public CanvasDockNodeCommand(Node parent, Node candidate) {
        this.parent = parent;
        this.candidate = candidate;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        this.getCandidate().getInEdges().stream().filter(e -> e.getContent() instanceof Child).findAny().ifPresent(e -> context.removeChild((Element)e.getSourceNode(), (Element)this.candidate));
        context.dock((Element)this.parent, (Element)this.candidate);
        context.applyElementMutation((Element)this.parent, MutationContext.STATIC);
        context.applyElementMutation((Element)this.candidate, MutationContext.STATIC);
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return new CanvasUndockNodeCommand(this.parent, this.candidate).execute(context);
    }

    public Node getParent() {
        return this.parent;
    }

    public Node<?, Edge> getCandidate() {
        return this.candidate;
    }

    public String toString() {
        return this.getClass().getName() + " [parent=" + this.getParent() + ", candidate=" + this.getCandidate() + "]";
    }
}

