/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.CanvasDockNodeCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;

public class CanvasUndockNodeCommand
extends AbstractCanvasCommand {
    private final Node parent;
    private final Node child;

    public CanvasUndockNodeCommand(Node parent, Node child) {
        this.parent = parent;
        this.child = child;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        context.undock((Element)this.parent, (Element)this.child);
        context.applyElementMutation((Element)this.parent, MutationContext.STATIC);
        context.applyElementMutation((Element)this.child, MutationContext.STATIC);
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return new CanvasDockNodeCommand(this.parent, this.child).execute(context);
    }

    public Node getParent() {
        return this.parent;
    }

    public Node getChild() {
        return this.child;
    }

    public String toString() {
        return this.getClass().getName() + " [parent=" + this.getUUID((Element<?>)this.parent) + ", candidate=" + this.getUUID((Element<?>)this.child) + "]";
    }
}

